/*
 * Decompiled with CFR 0.152.
 */
package com.mobiion;

import com.mobiion.BlackberryLight;
import com.mobiion.LightControl;
import com.mobiion.MainCanvas;
import com.mobiion.MotoLight;
import com.mobiion.NokiaLight;
import com.mobiion.SamsungLight;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.UDPDatagramConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class IPCamera
extends MIDlet
implements CommandListener,
Runnable {
    final String[] resEng = new String[]{"Camera List", "OK", "Exit", "Back", "Refresh", "IP Camera Player", "Camera Hostname or IP", "User", "Password", "Camera list", "Confirmation", "Do you want to quit IP Camera Player?", "Yes", "No", "Error", "Failed to open UDP server port", "Failed to connect to camera", "User or password incorrect", "Port", "Alias", "Frames", "Bytes", "Resolution", "Connecting to camera..."};
    final String[] resChs = new String[]{"\u6444\u50cf\u5934\u5217\u8868", "\u786e\u5b9a", "\u9000\u51fa", "\u8fd4\u56de", "\u5237\u65b0", "IP Camera Player", "\u6444\u50cf\u5934IP\u5730\u5740\u6216\u57df\u540d", "\u7528\u6237\u540d", "\u5bc6\u7801", "\u6444\u50cf\u5934\u5217\u8868", "\u786e\u8ba4", "\u786e\u5b9e\u8981\u9000\u51faIP Camera Player\u5417\uff1f", "\u662f", "\u5426", "\u8d85\u65f6", "\u65e0\u6cd5\u6253\u5f00UDP\u670d\u52a1\u7aef\u53e3", "\u8fde\u63a5\u6444\u50cf\u5934\u5931\u8d25", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef", "\u7aef\u53e3", "\u522b\u540d", "\u5e27\u6570", "\u6d41\u91cf", "\u5206\u8fa8\u7387", "\u6b63\u5728\u8fde\u63a5..."};
    Form camForm;
    List camList = null;
    Thread udpListner;
    UDPDatagramConnection udpConn = null;
    String[] res;
    TextField hostTextField;
    TextField userTextField;
    TextField passTextField;
    TextField portTextField;
    TextField aliasTextField;
    public Command exitCommand;
    private Command okCommand;
    private Command listCommand;
    public Command backCommand;
    public Command refreshCommand;
    public ChoiceGroup resolutionGroup;
    public LightControl lightControl = null;

    public void ShowException(String title, String error, boolean exit) {
        Display now;
        Displayable next;
        Alert tb = new Alert(title, error, null, AlertType.ERROR);
        if (exit) {
            tb.addCommand(this.exitCommand);
            tb.setTimeout(-2);
            tb.setCommandListener((CommandListener)this);
        }
        if ((next = (now = Display.getDisplay((MIDlet)this)).getCurrent()) != null && !(next instanceof Alert)) {
            now.setCurrent(tb, next);
        } else {
            now.setCurrent((Displayable)tb);
        }
    }

    private void initLightControl() {
        try {
            Class.forName("com.nokia.mid.ui.DeviceControl");
            this.lightControl = new NokiaLight();
            return;
        }
        catch (Exception e) {
            try {
                Class.forName("net.rim.device.api.system.Backlight");
                this.lightControl = new BlackberryLight();
                return;
            }
            catch (Exception e2) {
                try {
                    Class.forName("com.samsung.util.LCDLight");
                    this.lightControl = new SamsungLight();
                    return;
                }
                catch (Exception e3) {
                    try {
                        Class.forName("com.motorola.multimedia.Lighting");
                        this.lightControl = new MotoLight();
                        return;
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            }
        }
    }

    public IPCamera() {
        this.initLightControl();
        String locale = System.getProperty("microedition.locale");
        this.res = "zh-CN".equals(locale) ? this.resChs : this.resEng;
        this.listCommand = new Command(this.res[0], 8, 1);
        this.okCommand = new Command(this.res[1], 4, 1);
        this.exitCommand = new Command(this.res[2], 7, 1);
        this.backCommand = new Command(this.res[3], 2, 1);
        this.refreshCommand = new Command(this.res[4], 8, 1);
        this.camForm = new Form(this.res[5]);
        this.hostTextField = new TextField(this.res[6], null, 255, 4);
        this.portTextField = new TextField(this.res[18], null, 255, 2);
        this.userTextField = new TextField(this.res[7], null, 255, 4);
        this.passTextField = new TextField(this.res[8], null, 255, 65536);
        this.aliasTextField = new TextField(this.res[19], null, 255, 0);
        this.resolutionGroup = new ChoiceGroup(this.res[22], 1, new String[]{"640x480", "320x240", "160x120"}, null);
        this.resolutionGroup.setSelectedIndex(1, true);
        this.camForm.append((Item)this.aliasTextField);
        this.camForm.append((Item)this.hostTextField);
        this.camForm.append((Item)this.portTextField);
        this.camForm.append((Item)this.userTextField);
        this.camForm.append((Item)this.passTextField);
        this.camForm.append((Item)this.resolutionGroup);
        this.camForm.addCommand(this.exitCommand);
        this.camForm.addCommand(this.listCommand);
        this.camForm.addCommand(this.okCommand);
        this.camForm.setCommandListener((CommandListener)this);
    }

    public void destroyApp(boolean flag) {
        if (this.udpConn != null) {
            try {
                this.udpConn.close();
                this.udpConn = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void pauseApp() {
    }

    public void startApp() {
        if (Display.getDisplay((MIDlet)this).getCurrent() == null) {
            try {
                RecordStore rs = RecordStore.openRecordStore((String)"LastCamera", (boolean)true, (int)0, (boolean)false);
                byte[] bytes = rs.getRecord(1);
                if (bytes != null) {
                    this.hostTextField.setString(new String(bytes));
                }
                if ((bytes = rs.getRecord(2)) != null) {
                    this.userTextField.setString(new String(bytes));
                }
                if ((bytes = rs.getRecord(3)) != null) {
                    this.passTextField.setString(new String(bytes));
                }
                if ((bytes = rs.getRecord(4)) != null) {
                    this.portTextField.setString(new String(bytes));
                }
                if ((bytes = rs.getRecord(5)) != null) {
                    this.aliasTextField.setString(new String(bytes));
                }
                if ((bytes = rs.getRecord(6)) != null) {
                    this.resolutionGroup.setSelectedIndex((int)bytes[0], true);
                }
                rs.closeRecordStore();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.camForm);
            Display.getDisplay((MIDlet)this).setCurrentItem((Item)this.hostTextField);
        }
    }

    private void ProcessData(Datagram data) throws Exception {
        byte[] buff = data.getData();
        if (data.getLength() == 87 && buff[0] == 77 && buff[1] == 79 && buff[2] == 95 && buff[3] == 73 && buff[4] == 1 && buff[5] == 0) {
            int len = 0;
            for (int i = 0; i < 21 && buff[36 + i] != 0; ++i) {
                ++len;
            }
            String name = null;
            if (len > 0) {
                name = new String(buff, 36, len);
            } else {
                for (int i = 0; i < 13 && buff[23 + i] != 0; ++i) {
                    ++len;
                }
                if (len > 0) {
                    name = new String(buff, 23, len);
                }
            }
            StringBuffer addr = new StringBuffer(45);
            for (int i = 0; i < 4; ++i) {
                addr.append(buff[57 + i] & 0xFF);
                if (i >= 3) continue;
                addr.append('.');
            }
            addr.append(':');
            addr.append((buff[85] & 0xFF) << 8 | buff[86] & 0xFF);
            if (name != null) {
                addr.append(' ');
                addr.append(name);
            }
            this.camList.append(addr.toString(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread self = this.udpListner;
        UDPDatagramConnection conn = null;
        Exception ex = null;
        try {
            conn = (UDPDatagramConnection)Connector.open((String)"datagram://:");
        }
        catch (Exception e) {
            ex = e;
        }
        if (self != this.udpListner) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return;
        }
        this.udpConn = conn;
        if (ex != null) {
            this.ShowException("UDP Init", ex.toString(), false);
        }
        IPCamera e = this;
        synchronized (e) {
            this.notify();
        }
        if (this.udpConn == null) {
            return;
        }
        this.refreshList();
        try {
            Datagram data = this.udpConn.newDatagram(100);
            while (true) {
                data.reset();
                data.setLength(100);
                this.udpConn.receive(data);
                this.ProcessData(data);
            }
        }
        catch (Exception e2) {
            this.ShowException("UDP Thread", e2.toString(), true);
            return;
        }
    }

    public Datagram getLocalDatagram(byte[] buff) throws Exception {
        Datagram data = null;
        String add = this.udpConn.getLocalAddress();
        if (add != null && !add.startsWith("127.0.")) {
            boolean valid = true;
            int dot = 0;
            int lastdot = 0;
            for (int i = 0; i < add.length(); ++i) {
                char c = add.charAt(i);
                if (c >= '0' && c <= '9') continue;
                if (c == '.') {
                    ++dot;
                    lastdot = i;
                    continue;
                }
                valid = false;
                break;
            }
            if (valid && dot == 3) {
                String newBCAddr = "datagram://" + add.substring(0, lastdot) + ".255:10000";
                data = this.udpConn.newDatagram(buff, buff.length, newBCAddr);
            }
        }
        return data;
    }

    private void refreshList() {
        this.camList.deleteAll();
        boolean globalAddr = true;
        try {
            byte[] buff = new byte[]{77, 79, 95, 73, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
            Datagram data = null;
            Exception ex = null;
            try {
                data = this.udpConn.newDatagram(buff, buff.length, "datagram://255.255.255.255:10000");
            }
            catch (Exception e) {
                ex = e;
            }
            if (data == null) {
                globalAddr = false;
                data = this.getLocalDatagram(buff);
                if (data != null) {
                    ex = null;
                }
            }
            if (ex != null) {
                throw ex;
            }
            try {
                this.udpConn.send(data);
            }
            catch (IOException ioe) {
                boolean sent = false;
                if (globalAddr && (data = this.getLocalDatagram(buff)) != null) {
                    sent = true;
                    this.udpConn.send(data);
                }
                if (!sent) {
                    throw ioe;
                }
            }
        }
        catch (Exception e) {
            this.ShowException("Refresh List", e.toString(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (command == this.okCommand) {
            String res;
            String host = this.hostTextField.getString();
            if (this.portTextField.getString().length() > 0) {
                host = host + ':' + this.portTextField.getString();
            }
            switch (this.resolutionGroup.getSelectedIndex()) {
                case 0: {
                    res = "32";
                    break;
                }
                case 1: {
                    res = "8";
                    break;
                }
                case 2: {
                    res = "2";
                    break;
                }
                default: {
                    res = "8";
                }
            }
            MainCanvas mainCanvas = new MainCanvas(this, host, this.userTextField.getString(), this.passTextField.getString(), res);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)mainCanvas);
        } else if (command == this.listCommand) {
            if (this.camList == null) {
                this.camList = new List(this.res[9], 3);
                this.camList.addCommand(this.refreshCommand);
                this.camList.addCommand(this.backCommand);
                this.camList.setCommandListener((CommandListener)this);
            }
            if (this.udpConn == null) {
                try {
                    this.udpListner = new Thread(this);
                    this.udpListner.start();
                    IPCamera host = this;
                    synchronized (host) {
                        this.wait(20000L);
                    }
                }
                catch (Exception ex) {
                    this.ShowException("Show Camera List", ex.toString(), true);
                }
            }
            if (this.udpConn != null) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.camList);
            } else {
                Alert alert = new Alert(this.res[14], this.res[15], null, AlertType.ERROR);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
            }
        } else if (command == this.refreshCommand) {
            this.refreshList();
        } else if (command == this.backCommand) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.camForm);
        } else if (command == List.SELECT_COMMAND) {
            String ip = this.camList.getString(this.camList.getSelectedIndex());
            int index = ip.indexOf(32);
            if (index > 0) {
                this.aliasTextField.setString(ip.substring(index + 1));
                ip = ip.substring(0, index);
            }
            index = ip.indexOf(58);
            this.hostTextField.setString(ip.substring(0, index));
            this.portTextField.setString(ip.substring(index + 1));
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.camForm);
        }
    }
}

