<?php
	/*
	 * ==============================================================================
	 * BBC iPlayer for Xtreamer Media Player & Streamer
	 * ==============================================================================
	 *
	 * This project allows to watch content brom BBC iPlayer, which is supported
	 * on Linux by get_iplayer PERL script.
	 *
	 * Licence: GNU General Public License v2
	 * http://www.gnu.org/licenses/gpl.html
	 *
	 * Do not remove or change any header comments! Respect our work!
	 *
	 * If you are satisfied with my work you can support it with small donation                                                                                                                               
	 *   https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=SB8WDDAWY5YZE&lc=SI&item_name=xJukebox&item_number=ak5349jgdr&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted	 *
	 *
	 * Author: vpeter/misek
	 *
	 * ==============================================================================
	 */

/**
 * ==============================================================================
 * xJukebox - Xtreamer Community Jukebox for the Xtreamer Media Player & Streamer
 * ==============================================================================
 *
 * xJukebox (xjb) is a community project started by Cap, exe, mavvy and XenDE
 * hand in hand with the community and the Xtreamer company. Please visit the
 * official website for more information: http://www.xtreamer.net
 *
 * Licence: GNU General Public License v2
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Do not remove or change any header comments! Respect our work!
 * Visit us at http://forum.xtreamer.net or on irc://chat.xtreamer.net/xtreamer
 *
 * PHP + code structure: .......... XenDE (daniel@mameso.com)
 * PHP + RSS: ..................... exe (funpc3@googlemail.com)
 * PHP + SQLiteDB + WebUI: ........ mavvy (xtreamer@mavvy.net)
 * RSS/XML guru: .................. Cap (uphappy@gmail.com)
 * PHP + Online Scrapers .......... ozolli (ozolli@gmail.com)
 * PHP + RSS Templates ............ xdreamer
 * LINUX solutions: ............... vpeter
 * PHP: ........................... spare (email@jankamp.com)
 * PHP + Translations: ............ colombeen (info@colombeen.be)
 *
 * ==============================================================================
 * Attention: some parts have different licences.
 * ==============================================================================
 */

class xEpg_Db {
	/**
	 * Singleton instance
	 *
	 * Property is protected to allow extension by overriding {@link getInstance()}.
	 *
	 * @var Zend_Controller_Front
	 */
	protected static $_instance = null;

	/**
	 * @var string
	 */
	private $dbDSN = NULL;

	/**
	 * the PDO database- only useable in this class - direct using from outside not allowed
	 *
	 * @var PDO
	 */
	public $databasePDO = NULL;

	//SLO 1, Fr 6.8.2010, 20:00 30min, Danes dol, jutri gor, Tu
	
	private $sqlCreateTables = <<< SQL_COMMANDS
DROP TABLE IF EXISTS "tv";
CREATE TABLE 'tv' (
		'index'				LONG,
		'type'        TEXT,
		'name'        TEXT,
		'pid'         TEXT,
		'available'   TEXT,
		'episode'     TEXT,
		'seriesnum'   TEXT,
		'episodenum'  TEXT,
		'versions'    TEXT,
		'duration'    TEXT,
		'desc'        TEXT,
		'channel'     TEXT,
		'categories'  TEXT,
		'thumbnail'   TEXT,
		'timeadded'   TEXT,
		'guidance'    TEXT,
		'web'         TEXT
	);


SQL_COMMANDS;


	/**
	 * Singleton instance - only one instance of this class allowed
	 *
	 * @return Db
	 */
	public static function getInstance () {
		if (self::$_instance === null) {
			self::$_instance = new self();
		}
		
		return self::$_instance;
	}


	function __construct () {
		$db_file = './' . 'cache.db';
		$this->dbDSN = "sqlite:" . $db_file;
		if (! file_exists($db_file)) # if no Database file exist, create new one with table create sql
			$this->createEmptyDB();
			
		$this->connectDB();
	}


	function __destruct () {
		if (! is_null($this->databasePDO))
			$this->databasePDO = NULL;
	}


	private function connectDB () {
		if (is_null($this->databasePDO)) {
			# open or create the database file
			try {
				$this->databasePDO = new PDO($this->dbDSN);
				$this->databasePDO->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING);
				//$this->databasePDO->sqliteCreateFunction('regexp', 'xpvr_db_regexp', 2);
			} catch (PDOException $e) {
				echo $e->getMessage();
			}
		}
	}


	public function createEmptyDB () {
		$this->connectDB();
		try {
			$this->databasePDO->exec($this->sqlCreateTables);
		} catch (PDOException $e) {
			echo $e->getMessage();
		}
	
	}


	/**
	 * function for execute an query from outside this class
	 *
	 * @param string $query
	 */
	public function sqlExec ($query) {
		return $this->databasePDO->exec($query);
	}
}

	# begin own SQL extensions

	function xpvr_db_regexp ($pattern, $string) {
		$pattern = sprintf('\'%s\'', $pattern);
		return preg_match($pattern, $string);
	}

/* end */
