<?php
	/*
	 * ==============================================================================
	 * BBC iPlayer for Xtreamer Media Player & Streamer
	 * ==============================================================================
	 *
	 * This project allows to watch content brom BBC iPlayer, which is supported
	 * on Linux by get_iplayer PERL script.
	 *
	 * Licence: GNU General Public License v2
	 * http://www.gnu.org/licenses/gpl.html
	 *
	 * Do not remove or change any header comments! Respect our work!
	 *
	 * If you are satisfied with my work you can support it with small donation                                                                                                                               
	 *   https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=SB8WDDAWY5YZE&lc=SI&item_name=xJukebox&item_number=ak5349jgdr&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted	 *
	 *
	 * Author: vpeter/misek
	 *
	 * ==============================================================================
	 */
	 
	 
require_once 'KLogger.php';
require_once('db.inc');
require_once('functions.php');

$log = new KLogger("log.txt" , KLogger::OFF);

  $thumburl = @$_GET['thumburl'];
  if (is_null($thumburl) || $thumburl == '')
    $thumburl = '';

  $webinfo = @$_GET['webinfo'];
  if (is_null($webinfo) || $webinfo == '')
    $webinfo = '';

	$thumburl = preg_replace('/(.*)_150_84(.*)/', '\\1_512_288\\2', $thumburl);
	echo $thumburl;

	$page = file_get_contents($webinfo);

	$dataLines = extractData2($page);
	writeFile($dataLines);


function writeFile($stringData) {
	$myFile = "/tmp/bbc_iplayer_show.dat";
	$fh = fopen($myFile, 'w') or die("can't open file");
	fwrite($fh, $stringData);
	fclose($fh);
}

/* URL  from DB */
function extractData2($page) {
	$ret = '';
	$lineNr = 0;
	
	// first is thumb url
	
	$page = preg_replace('/\s+/', ' ', $page);

	$title1 = trim(getStringBetween($page, '<title>', '</title>'));

	$title2 = strip_tags(getStringBetween($page, '<div id="parents" class="box first">', ' <div'));
	$title2 = preg_replace('/Episode ([0-9]+) of ([0-9]+) from/', 'of \\2', $title2);
	$title = fixLength($title1 .' '. $title2);
	$ret .= "$title\n";
	$lineNr++;

	//$synopsis = fixLength(html_entity_decode(strip_tags(getStringBetween($page, '<div id="synopsis" class="blq-clearfix">', '</div>'))));
	$synopsis = html_entity_decode(strip_tags(getStringBetween($page, '<div id="synopsis" class="blq-clearfix">', '</div>')));
	$synopsis = fixLength(preg_replace('/&#39;/', '\'', $synopsis));
	$ret .= "$synopsis\n";
	$lineNr++;

	$duration = strip_tags(getStringBetween($page, '<div id="duration" class="box">', '</div>'));
	$duration = fixLength(preg_replace('/Duration/', '', $duration));
	$ret .= "$duration\n";
	$lineNr++;

	$categories = getStringBetween($page, '<div id="more-like-this" class="box">', '</dl>');
	$categories = preg_replace('/<ul class="clearfix">/', '', $categories, 1);
	$categories = preg_replace('/<ul class="clearfix">/', '|', $categories);
	$categories = preg_replace('/&#39;/', '\'', $categories);
	$categories = strip_tags(getStringBetween($categories, '<ul id="genres" class="clearfix">', '</dd>'));
	$categories = preg_replace('/\s+/', ' ', $categories); 
	$arr = explode('|', $categories);
	$ret .=  ($lineNr + count($arr)) ."\n";
	$lineNr++;
	foreach($arr as $key => $val) {
		$ret .= fixLength(html_entity_decode(trim($val))) ."\n";
		$lineNr++;
	}
			
	$availability = getStringBetween($page, 'Availability:', '</div>');
	$availability = trim(strip_tags($availability));
	$availability = trim(preg_replace('/\(why\?\)/', '', $availability));
	$availability = trim(preg_replace('/ \(or download at BBC iPlayer\)/', '', $availability));
	$availability = trim(preg_replace('/ \(see all broadcasts\)/', '', $availability));
	$availability = trim(preg_replace('/(Last broadcast)/', '|\\1', $availability));
	$arr = explode('|', $availability);
	$ret .=  ($lineNr + count($arr)) ."\n";
	$lineNr++;
	foreach($arr as $key => $val) {
		$ret .= fixLength($val) ."\n";
		$lineNr++;
	}

	$credits = getStringBetween($page, '<h2>Credits</h2>', '</div>');
	$credits = preg_replace('/<\/span>/', '|', $credits);
	$credits = strip_tags($credits);
	$arr = explode('|', $credits);
	$ret .=  ($lineNr + intval(count($arr)/2)) ."\n";
	$lineNr++;
	for ($i=0; $i < count($arr)-1; $i += 2) {
		$ret .=  fixLength($arr[$i]) .' '. fixLength($arr[$i+1]) ."\n";
		$lineNr++;
	}

	$broadcasts = getStringBetween($page, '<div id="broadcasts">', ' </ol>');
	$broadcasts = preg_replace('/<li class="clearfix">/', '', $broadcasts, 1);
	$broadcasts = preg_replace('/<li class="clearfix">/', '|', $broadcasts);
	$broadcasts = preg_replace('/(Broadcast[s]?)/', '', $broadcasts);
	$broadcasts = strip_tags($broadcasts);
	$arr = explode('|', $broadcasts);
	$ret .=  ($lineNr + count($arr)) ."\n";
	$lineNr++;
	foreach($arr as $key => $val) {
		$ret .= fixLength($val) . "\n";
		$lineNr++;
	}
	
	return $ret;
}

function fixLength($str) {
	$str = trim($str);
	if (strlen($str) == 0)
		$str = ' ';
	return $str;
}

?>
