<?php
	/*
	 * ==============================================================================
	 * BBC iPlayer for Xtreamer Media Player & Streamer
	 * ==============================================================================
	 *
	 * This project allows to watch content brom BBC iPlayer, which is supported
	 * on Linux by get_iplayer PERL script.
	 *
	 * Licence: GNU General Public License v2
	 * http://www.gnu.org/licenses/gpl.html
	 *
	 * Do not remove or change any header comments! Respect our work!
	 *
	 * If you are satisfied with my work you can support it with small donation                                                                                                                               
	 *   https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=SB8WDDAWY5YZE&lc=SI&item_name=xJukebox&item_number=ak5349jgdr&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted	 *
	 *
	 * Author: vpeter/misek
	 *
	 * ==============================================================================
	 */
	 
require_once 'KLogger.php';
require_once('db.inc');
require_once('functions.php');

$log = new KLogger("log.txt" , KLogger::OFF);

echo '<?xml version="1.0" encoding="UTF-8" ?>';
echo "\n<items>\n";

  $type = @$_GET['type'];
  if (is_null($type) || $type == '')
    $type = 'category';

	$search = @$_GET['search'];
	if (is_null($search) || $search == '')
	  $search = '';

	$log->LogDebug("search_items: type: '$type' search: '$search'");
	
	$pieces = explode(',', $search);
	$MySearch = 'WHERE (';
	foreach($pieces as $i => $val) {
		if ($i >= 1)
			$MySearch .= ' AND ';
		
		/* get only first portition (Children's => Children) */
		$i = strpos($val, "'");
		if ($i > 0)
			$val = substr($val, 0, $i-1);
		
		if ($type == 'category')
			$MySearch .= "categories LIKE '%$val%'";
		else if ($type == 'desc')
			$MySearch .= "(name LIKE '%$val%' OR desc LIKE '%$val%')";
	}
	$MySearch .= ')';
	
	if ($type == 'all')
		$MySearch = '';
	
	$log->LogDebug("search_items: MySearch: '$MySearch'");
	
  $mySelect = xEpg_Db::getInstance()->databasePDO->prepare("SELECT * FROM tv $MySearch ORDER BY 'index' ASC;");
	$mySelect->execute();
	$result = $mySelect->fetchAll(PDO::FETCH_OBJ);
		if (count($result) > 0) {
			foreach ($result as $row) {
			//echo "\n";
			//echo
				':index'			 .' '. $row->index		   ."\n".
				':type'        .' '. $row->type        ."\n".
				':name'        .' '. $row->name        ."\n".
				':pid'         .' '. $row->pid         ."\n".
				':available'   .' '. $row->available   ."\n".
				':episode'     .' '. $row->episode     ."\n".
				':seriesnum'   .' '. $row->seriesnum   ."\n".
				':episodenum'  .' '. $row->episodenum  ."\n".
				':versions'    .' '. $row->versions    ."\n".
				':duration'    .' '. $row->duration    ."\n".
				':desc'        .' '. $row->desc        ."\n".
				':channel'     .' '. $row->channel     ."\n".
				':categories'  .' '. $row->categories  ."\n".
				':thumbnail'   .' '. $row->thumbnail   ."\n".
				':timeadded'   .' '. $row->timeadded   ."\n".
				':guidance'    .' '. $row->guidance    ."\n".
				':web'         .' '. $row->web         ."\n";

				//break;
				
			$timeadded = date("D, d M Y", $row->timeadded);
/*
:episode Episode 1
:seriesnum 
:episodenum 1

:episode 13. Perfect Picnic
:seriesnum 1
:episodenum 13

S1E14: 14. title
remove 14.

E2: 2. title
*/
			/* remove leading number */
			$episode = $row->episode;
			$episode = preg_replace('/([0-9\. ]*)(.*)/', '$2', $episode);

			if ($row->seriesnum != "") {
				$series = 'S' . $row->seriesnum . 'E' . $row->episodenum . ': ' . $episode;
			} else {
				$series = 'E' . $row->episodenum . ': ' . $episode;
			}
			
			add_item($row->name .' - '. $row->desc, $row->thumbnail, $row->pid, $row->channel, $timeadded, $series, $row->web);
		}
	}
?>

</items>
