#!/bin/sh

# ==============================================================================
# BBC iPlayer for Xtreamer Media Player & Streamer
# ==============================================================================
#
# This project allows to watch content brom BBC iPlayer, which is supported
# on Linux by get_iplayer PERL script.
#
# Licence: GNU General Public License v2
# http://www.gnu.org/licenses/gpl.html
#
# Do not remove or change any header comments! Respect our work!
#
# If you are satisfied with my work you can support it with small donation                                                                                                                               
#   https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=SB8WDDAWY5YZE&lc=SI&item_name=xJukebox&item_number=ak5349jgdr&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted	 *
#
# Author: vpeter/misek
#
# ==============================================================================

#######################################################################################################################################
SDA1_DIR=/tmp/usbmounts/sda1
MAIN_DIR=${SDA1_DIR}/scripts/BBC-iPlayer
RECORDING_OUTPUT_DIR=${SDA1_DIR}/recordings
#######################################################################################################################################

# my perl must be first
export PATH=${SDA1_DIR}/perl/bin:${MAIN_DIR}/bin:$PATH 

# The environment variables GETIPLAYERUSERPREFS and GETIPLAYERSYSPREFS are used,
# if they are set, to override the get_iplayer user and system preferences directories
export GETIPLAYERUSERPREFS=${MAIN_DIR}/.get_iplayer
export GETIPLAYERSYSPREFS=${MAIN_DIR}/.get_iplayer/options

# undefined commands
STAT="$MAIN_DIR/bin/busybox stat"

