#!/bin/sh

# ==============================================================================
# BBC iPlayer for Xtreamer Media Player & Streamer
# ==============================================================================
#
# This project allows to watch content brom BBC iPlayer, which is supported
# on Linux by get_iplayer PERL script.
#
# Licence: GNU General Public License v2
# http://www.gnu.org/licenses/gpl.html
#
# Do not remove or change any header comments! Respect our work!
#
# If you are satisfied with my work you can support it with small donation                                                                                                                               
#   https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=SB8WDDAWY5YZE&lc=SI&item_name=xJukebox&item_number=ak5349jgdr&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted	 *
#
# Author: vpeter/misek
#
# ==============================================================================

# load environment variable
. /tmp/usbmounts/sda1/scripts/BBC-iPlayer/bin/env_setup.sh

STREAM_LOG=${MAIN_DIR}/stream.log

# http://127.0.0.1/cgi-bin/BBC-iPlayer_cgi.sh?content=flv&amp;pid=b007rx1j

# test
# 	QUERY_STRING="content=flv&pid=b007rx1j" /sbin/www/cgi-bin/iPlayer.cgi >brisi


CONTENT=`echo "$QUERY_STRING" | sed -n -e 's/^.*content=\([^&]*\).*$/\1/p' -e "s/%20/ /g" 2>/dev/null`
TYPE=`echo "$QUERY_STRING" | sed -n -e 's/^.*type=\([^&]*\).*$/\1/p' -e "s/%20/ /g" 2>/dev/null`
WHAT=`echo "$QUERY_STRING" | sed -n -e 's/^.*what=\([^&]*\).*$/\1/p' -e "s/%20/ /g" 2>/dev/null`
WHAT=`echo $WHAT | sed "s/%20/ /g" 2>/dev/null`

#echo -e "CONTENT: '$CONTENT' \n   TYPE: '$TYPE' \n   WHAT: '$WHAT'" >/tmp/iplayer_cgi.log
#echo "QUERY_STRING: $QUERY_STRING" >>/tmp/iplayer_cgi.log

if [ "$CONTENT" == "flv" ]; then
	# web server prepare real 200 OK response
	#echo "Content-type: video/x-flv"

#	echo -e "Content-type: video/x-flv
#
#";

################################################################################
#Accept-Ranges: bytes
cat << EOF_CONTENT_TYPE
Content-type: video/x-flv

EOF_CONTENT_TYPE

	# Record to standard output
	if [ "$TYPE" == "tv" ]; then
		exec perl $MAIN_DIR/bin/get_iplayer --type=tv --pid=$WHAT --stream 2>$STREAM_LOG
	else if [ "$TYPE" == "livetv" ]; then
		exec perl $MAIN_DIR/bin/get_iplayer --type=livetv --channel="$WHAT" --stream 2>$STREAM_LOG
	fi; fi
	exit
fi

################################################################################
if [ "$CONTENT" == "mp4a" ]; then
cat << EOF_CONTENT_TYPE
Content-type: audio/mp4a-latm

EOF_CONTENT_TYPE

	exit
fi

################################################################################
if [ "$CONTENT" == "mp3" ]; then
cat << EOF_CONTENT_TYPE
Content-type: audio/x-mp3

EOF_CONTENT_TYPE

	exit
fi

################################################################################
if [ "$CONTENT" == "aac" ]; then
cat << EOF_CONTENT_TYPE
Content-type: audio/aac

EOF_CONTENT_TYPE

	exit
fi


################################################################################
echo -e "Content-type: text/html

";

echo -e "Some error happen! (CONTENT: $CONTENT   TYPE: $TYPE   WHAT: $WHAT)
";

exit
