<?php
	/*
	 * ==============================================================================
	 * BBC iPlayer for Xtreamer Media Player & Streamer
	 * ==============================================================================
	 *
	 * This project allows to watch content brom BBC iPlayer, which is supported
	 * on Linux by get_iplayer PERL script.
	 *
	 * Licence: GNU General Public License v2
	 * http://www.gnu.org/licenses/gpl.html
	 *
	 * Do not remove or change any header comments! Respect our work!
	 *
	 * If you are satisfied with my work you can support it with small donation                                                                                                                               
	 *   https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=SB8WDDAWY5YZE&lc=SI&item_name=xJukebox&item_number=ak5349jgdr&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted	 *
	 *
	 * Author: vpeter/misek
	 *
	 * ==============================================================================
	 */

require_once('db.inc');
	// create lock file so we know when update is finished
	$lock_file = '/tmp/force_update.lock';
	touch($lock_file);
	
	$cmd = "/bin/sh refresh_cache_tv.sh force >/dev/null 2>&1 &";
	system($cmd);

echo '<?xml version="1.0" encoding="UTF-8" ?>'; 
?>

<rss version="2.0" xmlns:dc="http://purl.org/dc/elements/1.1/">
  <!-- ---------------------------------------------------------  -->
  <!-- RSS DEBUG RSS FUNCTION WILL WRITE ENTRY IN debug.txt FILE  -->
  <!-- syntax: txt = "string to write"; executeScript("log");     -->
  <log>
    old = readStringFromFile("/tmp/usbmounts/sda1/debug.txt");
    new = old + "&#x0A;" + date("%d.%m.%Y %H:%M:%S") + ": " + txt;
    writeStringToFile("/tmp/usbmounts/sda1/debug.txt", new);
  </log>
  <!-- ---------------------------------------------------------  -->

<onEnter>
	txt = "onEnter update"; executeScript("log");
	showIdle();
	setRefreshTime(1000);
</onEnter>

<onRefresh>
	txt = "string to write <?= $lock_file ?>"; executeScript("log");
	rv = CheckFile("<?= $lock_file ?>");
	txt = "string to write -" + rv + "-"; executeScript("log");
	if (rv == "false") {
		setRefreshTime(-1);
		cancelIdle();
		postMessage("RET");
	} else
		setRefreshTime(1000);
</onRefresh>
 
<onExit>
	txt = "onExit update"; executeScript("log");
  setRefreshTime(-1);
</onExit>
  
<mediaDisplay name=onePartView
sideColorLeft="0:0:0"
sideLeftWidthPC="18"
sideRightWidthPC="10"
sideColorRight="0:0:0"
headerXPC="14"
headerYPC="3"
headerWidthPC="95"
itemImageXPC="21"
itemImageYPC="18"
itemXPC="34"
itemYPC="18"
itemWidthPC="46"
menuXPC="5"
menuWidthPC="15"
capXPC="82"
capYPC="17"
capHeightPC="10"
headerCapXPC="90"
headerCapYPC="10"
headerCapWidthPC="0"
showDefaultInfo=no
backgroundColor="0:0:0"

infoYPC="85"
popupXPC="7"
popupWidthPC="15"
popupBorderColor="0:0:0"
idleImageXPC=45
idleImageYPC=42
idleImageWidthPC=10
idleImageHeightPC=16

showHeader="no"
parentFocusFontColor="28:134:238"
imageFocus="selection.bmp"
imageParentFocus="selection.bmp"
forceFocusOnItem="yes"
selectMenuOnRight="yes"
>

<idleImage> image/POPUP_LOADING_01.jpg </idleImage>
<idleImage> image/POPUP_LOADING_02.jpg </idleImage>
<idleImage> image/POPUP_LOADING_03.jpg </idleImage>
<idleImage> image/POPUP_LOADING_04.jpg </idleImage>
<idleImage> image/POPUP_LOADING_05.jpg </idleImage>
<idleImage> image/POPUP_LOADING_06.jpg </idleImage>

	<backgroundDisplay>
  	<image offsetXPC=0 offsetYPC=0 widthPC=100 heightPC=100>
    	/tmp/usbmounts/sda1/scripts/BBC-iPlayer/back.png
    </image>
    <text redraw="yes" tailDots="yes" offsetXPC=15 offsetYPC=20 widthPC=100 heightPC=60 fontSize=16 backgroundColor=-1:-1:-1 foregroundColor=255:255:255 lines=10>
      Now wait for few minutes and update will complete.&#x0A;You will be returned to main screen after that.&#x0A;&#x0A;You can also return manualy and use the application&#x0A;but some programmes will not be shown or they will not work.
    </text>
  </backgroundDisplay>

</mediaDisplay>

<channel>
<title>BBC iPlayer</title>
<link>/tmp/usbmounts/sda1/scripts/BBC-iPlayer/main.rss</link>
<media:thumbnail url="/tmp/usbmounts/sda1/scripts/BBC-iPlayer/bbc-iplayer.jpg" />

</channel>
</rss>
