<?php
#############################################################################
# Author: consros    2011                                                   #
#############################################################################

require_once 'tools/http.inc';
require_once 'tools/parser.inc';

class Video {

    public static function getVideoYoutube($id, $http = null) {
        if (null == $http) {
            $http = new HttpTools();
        }
        $url  = 'http://www.youtube.com/watch?v=' . $id;
        $html = $http->sendGetRequest($url);

# 'PLAYER_CONFIG'

        if (! preg_match('/url_encoded_fmt_stream_map=(.*?)\&/s',$s,$ss)>0) {
            return false;
        }

        $ss = urldecode($ss[1]);
        $ss = urldecode($ss).';';

        $streams = array();
        if (preg_match_all('/url=(.*?\&itag=(\d*).*?)[\;\,]/',$ss,$ss)>0) {
            foreach($ss[2]as$i=>$itag) {
                $streams[$itag]=$ss[1][$i];
            }
        }
        // 22 - HD720
        // 18 - MEDIUM(default)
        if (isset($streams[22])) {
            return $streams[22];
        }
        if (isset($streams[18])) {
            return $streams[18];
        }
        return false;
    }

    public static function getVideoVkontakte($url, $http = null) {
        $html = null != $http ? $http->sendGetRequest($url) :
            file_get_contents($url, false);

        $host  = ParserTools::parseParam($html, "var video_host = '",   "'");
        $uid   = ParserTools::parseParam($html, "var video_uid = '",    "'", 0);
        $vtag  = ParserTools::parseParam($html, "var video_vtag = '",   "'");
        $hd    = ParserTools::parseParam($html, "var video_max_hd = '", "'", 0);
        $noflv = ParserTools::parseParam($html, "var video_no_flv = ", ";", '');
        $noflv = false !== strpos($noflv, '1');

        # removed videos
        if (null == $host) {
            return array();
        }

        # flv support
        if ($uid <= 0) {
            if ($noflv) {
                return array();
            }
            $vkid = ParserTools::parseParam($html, 'vkid=', '&');
            return array('FLV' => "http://$host/assets/videos/$vtag$vkid.vk.flv");
        }

        static $hds = array('240', '360', '480', '720');

        # mp4 link by default
        $videos = array();
        for ($i = 0; $i <= $hd; $i++) {
            $res = $hds[$i];
            $videos["MP4 $res"] = $host . "u$uid/video/$vtag.$res.mp4";
        }
        return $videos;
    }

    public static function playVideoVkontakte($title, $video, $http = null) {
        global $lang;
        $videos  = Video::getVideoVkontakte($video, $http);
        if (0 == count($videos)) {
            return new Message($lang->msg('Message'), $lang->msg(
                'No playable videos found, probably 3d party player is used'));
        }
        $videos  = array_reverse($videos, true);
        $channel = new Channel($lang->msg('Quality selection'));
        $channel->setSupportedTemplates(1 == count($videos) ?
            'auto-open' : 'context-menu');
        foreach ($videos as $quality => $url) {
            $item = new Item($title, $quality);
            $item->addEnclosure($url, 'video/mp4');
            $channel->addItem($item);
        }
        return $channel;
    }
}
?>
