<?php
/**
* Smarty Internal Plugin Templateparser
*
* This is the template parser.
* It is generated from the internal.templateparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

class TP_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TP_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};


#line 12 "smarty_internal_templateparser.y"
class Smarty_Internal_Templateparser#line 79 "smarty_internal_templateparser.php"
{
#line 14 "smarty_internal_templateparser.y"

	  const Err1 = "Security error: Call to private object member not allowed";
	  const Err2 = "Security error: Call to dynamic object member not allowed";
    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    private $lex;
    private $internalError = false;

    function __construct($lex, $compiler) {
        // set instance object
        self::instance($this); 
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->smarty = $this->compiler->smarty;
        $this->template = $this->compiler->template;
        $this->compiler->has_variable_string = false;
				$this->compiler->prefix_code = array();
				$this->prefix_number = 0;
				$this->block_nesting_level = 0;
				if ($this->security = isset($this->smarty->security_policy)) {
              $this->php_handling = $this->smarty->security_policy->php_handling;
        } else {
              $this->php_handling = $this->smarty->php_handling;
        }
				$this->is_xml = false;
				$this->asp_tags = (ini_get('asp_tags') != '0');
				$this->current_buffer = $this->root_buffer = new _smarty_template_buffer($this);
    }
    public static function &instance($new_instance = null)
    {
        static $instance = null;
        if (isset($new_instance) && is_object($new_instance))
            $instance = $new_instance;
        return $instance;
    }

    public static function escape_start_tag($tag_text) {
       $tag = preg_replace('/\A<\?(.*)\z/', '<<?php ?>?\1', $tag_text, -1 , $count); //Escape tag
       assert($tag !== false && $count === 1);
       return $tag;
    }

    public static function escape_end_tag($tag_text) {
       assert($tag_text === '?>');
       return '?<?php ?>>';
    }

    
#line 132 "smarty_internal_templateparser.php"

    const TP_VERT                           =  1;
    const TP_COLON                          =  2;
    const TP_COMMENT                        =  3;
    const TP_PHPSTARTTAG                    =  4;
    const TP_PHPENDTAG                      =  5;
    const TP_ASPSTARTTAG                    =  6;
    const TP_ASPENDTAG                      =  7;
    const TP_FAKEPHPSTARTTAG                =  8;
    const TP_XMLTAG                         =  9;
    const TP_OTHER                          = 10;
    const TP_LINEBREAK                      = 11;
    const TP_LITERALSTART                   = 12;
    const TP_LITERALEND                     = 13;
    const TP_LITERAL                        = 14;
    const TP_LDEL                           = 15;
    const TP_RDEL                           = 16;
    const TP_DOLLAR                         = 17;
    const TP_ID                             = 18;
    const TP_EQUAL                          = 19;
    const TP_PTR                            = 20;
    const TP_LDELIF                         = 21;
    const TP_SPACE                          = 22;
    const TP_LDELFOR                        = 23;
    const TP_SEMICOLON                      = 24;
    const TP_INCDEC                         = 25;
    const TP_TO                             = 26;
    const TP_STEP                           = 27;
    const TP_LDELFOREACH                    = 28;
    const TP_AS                             = 29;
    const TP_APTR                           = 30;
    const TP_SMARTYBLOCKCHILD               = 31;
    const TP_LDELSLASH                      = 32;
    const TP_INTEGER                        = 33;
    const TP_COMMA                          = 34;
    const TP_MATH                           = 35;
    const TP_UNIMATH                        = 36;
    const TP_ANDSYM                         = 37;
    const TP_ISIN                           = 38;
    const TP_ISDIVBY                        = 39;
    const TP_ISNOTDIVBY                     = 40;
    const TP_ISEVEN                         = 41;
    const TP_ISNOTEVEN                      = 42;
    const TP_ISEVENBY                       = 43;
    const TP_ISNOTEVENBY                    = 44;
    const TP_ISODD                          = 45;
    const TP_ISNOTODD                       = 46;
    const TP_ISODDBY                        = 47;
    const TP_ISNOTODDBY                     = 48;
    const TP_INSTANCEOF                     = 49;
    const TP_OPENP                          = 50;
    const TP_CLOSEP                         = 51;
    const TP_QMARK                          = 52;
    const TP_NOT                            = 53;
    const TP_TYPECAST                       = 54;
    const TP_HEX                            = 55;
    const TP_DOT                            = 56;
    const TP_SINGLEQUOTESTRING              = 57;
    const TP_DOUBLECOLON                    = 58;
    const TP_AT                             = 59;
    const TP_HATCH                          = 60;
    const TP_OPENB                          = 61;
    const TP_CLOSEB                         = 62;
    const TP_EQUALS                         = 63;
    const TP_NOTEQUALS                      = 64;
    const TP_GREATERTHAN                    = 65;
    const TP_LESSTHAN                       = 66;
    const TP_GREATEREQUAL                   = 67;
    const TP_LESSEQUAL                      = 68;
    const TP_IDENTITY                       = 69;
    const TP_NONEIDENTITY                   = 70;
    const TP_MOD                            = 71;
    const TP_LAND                           = 72;
    const TP_LOR                            = 73;
    const TP_LXOR                           = 74;
    const TP_QUOTE                          = 75;
    const TP_BACKTICK                       = 76;
    const TP_DOLLARID                       = 77;
    const YY_NO_ACTION = 572;
    const YY_ACCEPT_ACTION = 571;
    const YY_ERROR_ACTION = 570;

    const YY_SZ_ACTTAB = 2394;
static public $yy_action = array(
 /*     0 */   192,  249,  282,  291,  295,  270,  277,  272,  269,  284,
 /*    10 */   287,  373,  349,  168,  155,  308,   39,  136,  138,    5,
 /*    20 */   320,   12,  222,  185,  228,  219,   12,  126,    7,  134,
 /*    30 */   303,  251,  246,  232,   48,   45,   44,   43,   26,   24,
 /*    40 */   255,  250,   16,   27,  267,  286,   14,   10,  364,  307,
 /*    50 */   298,  305,  313,   46,  185,  362,  168,  340,  365,    7,
 /*    60 */   192,   12,  266,  268,  271,  289,  239,  245,  257,  260,
 /*    70 */   254,  297,  353,  345,  192,  290,  302,  157,   13,  208,
 /*    80 */   224,  237,  229,   72,  140,  119,  571,   91,  252,  282,
 /*    90 */   291,  176,  363,  338,  273,   12,  327,  314,   13,  304,
 /*   100 */    41,  237,   30,  230,  196,  259,  195,  175,   48,   45,
 /*   110 */    44,   43,   26,   24,  255,  250,   16,   27,  267,  286,
 /*   120 */    14,   10,  211,  318,   13,  147,  439,  237,  100,   34,
 /*   130 */    13,   12,  439,  237,   30,  273,  266,  268,  271,  289,
 /*   140 */   239,  245,  257,  260,  254,  297,  353,  345,  192,  192,
 /*   150 */   302,  181,  148,    8,  224,  101,  229,   72,   13,  119,
 /*   160 */     5,  237,  273,  299,  264,  350,  363,  338,  126,   12,
 /*   170 */   327,  314,   46,  304,  214,  336,  293,  145,  181,  259,
 /*   180 */   201,   12,   48,   45,   44,   43,   26,   24,  255,  250,
 /*   190 */    16,   27,  267,  286,   14,   10,   13,    2,  309,  237,
 /*   200 */    18,   46,  214,  441,   12,   19,  279,  130,  330,  441,
 /*   210 */   266,  268,  271,  289,  239,  245,  257,  260,  254,  297,
 /*   220 */   353,  345,  192,  328,  302,  342,  360,  372,  224,  112,
 /*   230 */   229,   54,   12,  119,  127,   13,   46,  316,  237,  369,
 /*   240 */   363,  338,   12,   12,  327,  314,   32,  304,  124,  154,
 /*   250 */   233,  209,  311,   31,  170,  312,   48,   45,   44,   43,
 /*   260 */    26,   24,  255,  250,   16,   27,  267,  286,   14,   10,
 /*   270 */   192,  317,  315,    5,  435,  102,  367,   12,   12,  221,
 /*   280 */    12,  126,  131,  293,  266,  268,  271,  289,  239,  245,
 /*   290 */   257,  260,  254,  297,  353,  345,  304,  438,  355,  164,
 /*   300 */   343,   29,   29,  438,   48,   45,   44,   43,   26,   24,
 /*   310 */   255,  250,   16,   27,  267,  286,   14,   10,  339,  247,
 /*   320 */   248,  436,  181,   33,    4,   40,  138,  436,  114,  220,
 /*   330 */    46,  322,  266,  268,  271,  289,  239,  245,  257,  260,
 /*   340 */   254,  297,  353,  345,  192,  302,  159,  167,  347,  224,
 /*   350 */    13,  229,   72,  237,  119,    5,  273,   21,   22,  285,
 /*   360 */   209,  363,  338,  126,  121,  327,  314,  259,  304,    5,
 /*   370 */   181,   99,  231,  177,  312,  197,   29,  126,   48,   45,
 /*   380 */    44,   43,   26,   24,  255,  250,   16,   27,  267,  286,
 /*   390 */    14,   10,  192,  234,  326,  334,  306,  163,  156,  259,
 /*   400 */    12,   12,   12,  192,  293,   28,  266,  268,  271,  289,
 /*   410 */   239,  245,  257,  260,  254,  297,  353,  345,  435,  354,
 /*   420 */    13,  181,  348,  205,   12,   12,   48,   45,   44,   43,
 /*   430 */    26,   24,  255,  250,   16,   27,  267,  286,   14,   10,
 /*   440 */     6,  241,  150,  280,    6,  325,  293,   12,  301,   12,
 /*   450 */   210,   12,  273,  253,  266,  268,  271,  289,  239,  245,
 /*   460 */   257,  260,  254,  297,  353,  345,  192,   38,  180,  165,
 /*   470 */   152,   13,  122,   97,  237,  161,  324,  366,   12,  273,
 /*   480 */   273,   46,   23,   21,   22,  273,  204,  238,  222,  173,
 /*   490 */   228,  292,  111,   12,  133,  134,  181,   12,  246,  232,
 /*   500 */    48,   45,   44,   43,   26,   24,  255,  250,   16,   27,
 /*   510 */   267,  286,   14,   10,  256,  160,  172,  356,    3,   13,
 /*   520 */    12,  329,  227,   12,  369,  273,  174,   12,  266,  268,
 /*   530 */   271,  289,  239,  245,  257,  260,  254,  297,  353,  345,
 /*   540 */   192,  180,  357,   37,  370,  137,  294,  162,  333,  166,
 /*   550 */   192,  366,   12,  158,   12,  179,   23,  273,  303,  273,
 /*   560 */   281,  358,  222,  273,  228,  274,   12,  346,  259,  134,
 /*   570 */   259,  217,  246,  232,   48,   45,   44,   43,   26,   24,
 /*   580 */   255,  250,   16,   27,  267,  286,   14,   10,  192,  149,
 /*   590 */   368,   13,  215,  226,  207,   36,   11,  132,  138,  273,
 /*   600 */   192,   98,  266,  268,  271,  289,  239,  245,  257,  260,
 /*   610 */   254,  297,  353,  345,  303,  180,  359,   37,  370,  169,
 /*   620 */   312,   12,   48,   45,   44,   43,   26,   24,  255,  250,
 /*   630 */    16,   27,  267,  286,   14,   10,  121,  144,  216,  337,
 /*   640 */    13,  361,  236,  194,  210,  116,  132,  273,   12,  120,
 /*   650 */   266,  268,  271,  289,  239,  245,  257,  260,  254,  297,
 /*   660 */   353,  345,  192,  302,  300,  105,  123,  224,   94,  229,
 /*   670 */    55,   15,  119,  135,  129,  109,  192,  263,  303,  363,
 /*   680 */   338,  303,  143,  327,  314,  259,  304,  303,  303,  171,
 /*   690 */   335,  258,  273,  261,   90,  118,   48,   45,   44,   43,
 /*   700 */    26,   24,  255,  250,   16,   27,  267,  286,   14,   10,
 /*   710 */   192,   35,  323,  180,  311,  138,  153,  192,  113,  259,
 /*   720 */   351,   20,   12,   96,  266,  268,  271,  289,  239,  245,
 /*   730 */   257,  260,  254,  297,  353,  345,  303,  275,   25,   42,
 /*   740 */   276,  212,   95,  352,   48,   45,   44,   43,   26,   24,
 /*   750 */   255,  250,   16,   27,  267,  286,   14,   10,   93,  318,
 /*   760 */   318,  103,  318,  265,  318,  318,  318,  318,  318,  318,
 /*   770 */   318,  303,  266,  268,  271,  289,  239,  245,  257,  260,
 /*   780 */   254,  297,  353,  345,  192,  318,  302,  104,  318,  318,
 /*   790 */   224,  318,  229,   82,  318,  119,  318,  318,  318,  318,
 /*   800 */   303,  318,  363,  338,  318,   12,  327,  314,  318,  304,
 /*   810 */   318,  318,  318,  318,  318,  318,  318,  318,   48,   45,
 /*   820 */    44,   43,   26,   24,  255,  250,   16,   27,  267,  286,
 /*   830 */    14,   10,  192,  318,  318,  318,  318,  318,  318,  318,
 /*   840 */   318,  318,  318,  318,  318,  318,  266,  268,  271,  289,
 /*   850 */   239,  245,  257,  260,  254,  297,  353,  345,  318,  318,
 /*   860 */   318,  318,  318,  318,  318,  318,   48,   45,   44,   43,
 /*   870 */    26,   24,  255,  250,   16,   27,  267,  286,   14,   10,
 /*   880 */   318,  318,  318,  318,  318,  318,  318,  318,  318,  318,
 /*   890 */   318,  318,  318,  318,  266,  268,  271,  289,  239,  245,
 /*   900 */   257,  260,  254,  297,  353,  345,  192,  371,  302,  318,
 /*   910 */   318,  318,  224,  318,  229,   86,  318,  119,  318,  318,
 /*   920 */   318,  178,  318,  318,  363,  338,  318,  318,  327,  314,
 /*   930 */   318,  304,  318,  318,  318,  318,  318,  318,  318,  318,
 /*   940 */    48,   45,   44,   43,   26,   24,  255,  250,   16,   27,
 /*   950 */   267,  286,   14,   10,  192,  318,  318,  318,  318,  318,
 /*   960 */   318,  318,  318,  318,  318,  318,  318,  318,  266,  268,
 /*   970 */   271,  289,  239,  245,  257,  260,  254,  297,  353,  345,
 /*   980 */   318,  318,  206,  318,  318,  318,  318,  318,   48,   45,
 /*   990 */    44,   43,   26,   24,  255,  250,   16,   27,  267,  286,
 /*  1000 */    14,   10,  192,  318,  318,  318,  318,  318,  318,  318,
 /*  1010 */   318,  318,  318,  318,  318,  318,  266,  268,  271,  289,
 /*  1020 */   239,  245,  257,  260,  254,  297,  353,  345,  318,  318,
 /*  1030 */   318,  318,  318,  318,  318,  318,   48,   45,   44,   43,
 /*  1040 */    26,   24,  255,  250,   16,   27,  267,  286,   14,   10,
 /*  1050 */   318,  318,  318,  318,  318,  318,  318,  318,  318,  318,
 /*  1060 */   318,  318,  318,  318,  266,  268,  271,  289,  239,  245,
 /*  1070 */   257,  260,  254,  297,  353,  345,   48,   45,   44,   43,
 /*  1080 */    26,   24,  255,  250,   16,   27,  267,  286,   14,   10,
 /*  1090 */   318,  318,  318,  318,  318,  318,  318,  318,  318,  318,
 /*  1100 */   318,  318,  318,  318,  266,  268,  271,  289,  239,  245,
 /*  1110 */   257,  260,  254,  297,  353,  345,  318,  318,  318,  318,
 /*  1120 */    39,  318,  115,  186,  318,  302,  222,  318,  228,  319,
 /*  1130 */   318,  229,  318,  134,  119,  318,  246,  232,  223,  318,
 /*  1140 */   318,   50,  321,  441,  318,  327,  314,  318,  304,  441,
 /*  1150 */   318,  318,  318,  318,  318,    9,  225,  318,   47,   49,
 /*  1160 */   242,  218,  331,  318,  318,   99,    1,  262,  318,  318,
 /*  1170 */   318,   39,  318,  115,  199,  318,   46,  222,  318,  228,
 /*  1180 */    92,  318,  318,  318,  134,  318,  318,  246,  232,  223,
 /*  1190 */   318,  318,   50,  318,  318,  318,  318,  318,  302,  318,
 /*  1200 */   318,  318,  193,  318,  229,   85,    9,  119,  318,   47,
 /*  1210 */    49,  242,  218,  331,  363,  338,   99,    1,  327,  314,
 /*  1220 */   318,  304,   39,  318,  115,  187,  318,  318,  222,  318,
 /*  1230 */   228,   92,  200,  341,  318,  134,  318,  318,  246,  232,
 /*  1240 */   223,  318,  318,   50,  318,  318,  318,  318,  318,  302,
 /*  1250 */   318,  318,  318,  193,  318,  229,   85,    9,  119,  318,
 /*  1260 */    47,   49,  242,  218,  331,  363,  338,   99,    1,  327,
 /*  1270 */   314,  318,  304,   39,  318,  114,  199,  318,  318,  222,
 /*  1280 */   318,  228,   92,  318,  344,  318,  134,  318,  318,  246,
 /*  1290 */   232,  223,  318,  318,   50,  318,  318,  318,  318,  318,
 /*  1300 */   302,  318,  318,  318,  224,  318,  229,   67,   17,  119,
 /*  1310 */   318,   47,   49,  242,  218,  331,  363,  338,   99,    1,
 /*  1320 */   327,  314,  318,  304,   39,  318,  115,  190,  318,  318,
 /*  1330 */   222,  318,  228,   92,  318,  318,  318,  134,  318,  318,
 /*  1340 */   246,  232,  223,  318,  318,   50,  318,  318,  318,  318,
 /*  1350 */   318,  302,  318,  318,  318,  224,  318,  229,   68,    9,
 /*  1360 */   119,  318,   47,   49,  242,  218,  331,  363,  338,   99,
 /*  1370 */     1,  327,  314,  318,  304,   39,  318,  125,  199,  318,
 /*  1380 */   318,  222,  318,  228,   92,  318,  318,  318,  134,  318,
 /*  1390 */   318,  246,  232,  223,  318,  318,   50,  318,  318,  318,
 /*  1400 */   318,  318,  302,  318,  318,  318,  224,  318,  229,   77,
 /*  1410 */     9,  119,  318,   47,   49,  242,  218,  331,  363,  338,
 /*  1420 */    99,    1,  327,  314,  318,  304,   39,  318,  128,   89,
 /*  1430 */   318,  318,  222,  318,  228,   92,  318,  318,  318,  134,
 /*  1440 */   318,  318,  246,  232,  223,  318,  318,   50,  318,  318,
 /*  1450 */   318,  318,  318,  302,  318,  318,  318,  224,  318,  229,
 /*  1460 */    61,    9,  119,  318,   47,   49,  242,  218,  331,  363,
 /*  1470 */   338,   99,    1,  327,  314,  318,  304,   39,  318,  115,
 /*  1480 */   182,  318,  318,  222,  318,  228,   92,  318,  318,  318,
 /*  1490 */   134,  318,  318,  246,  232,  223,  318,  318,   50,  318,
 /*  1500 */   318,  318,  318,  318,  302,  318,  318,  318,  224,  318,
 /*  1510 */   229,   73,    9,  119,  318,   47,   49,  242,  218,  331,
 /*  1520 */   363,  338,   99,    1,  327,  314,  318,  304,   39,  318,
 /*  1530 */   115,  183,  318,  318,  222,  318,  228,   92,  318,  318,
 /*  1540 */   318,  134,  318,  318,  246,  232,  191,  318,  318,   50,
 /*  1550 */   318,  318,  318,  318,  318,  302,  318,  318,  318,  224,
 /*  1560 */   318,  229,   63,    9,  119,  318,   47,   49,  242,  218,
 /*  1570 */   331,  363,  338,   99,    1,  327,  314,  318,  304,   39,
 /*  1580 */   318,  117,  199,  318,  318,  222,  318,  228,   92,  318,
 /*  1590 */   318,  318,  134,  318,  318,  246,  232,  223,  318,  318,
 /*  1600 */    50,  318,  318,  318,  318,  318,  302,  318,  318,  318,
 /*  1610 */   224,  318,  229,   70,    9,  119,  318,   47,   49,  242,
 /*  1620 */   218,  331,  363,  338,   99,    1,  327,  314,  318,  304,
 /*  1630 */    39,  318,  114,  203,  318,  318,  222,  318,  228,   92,
 /*  1640 */   318,  318,  318,  134,  318,  318,  246,  232,  223,  318,
 /*  1650 */   318,   50,  318,  318,  318,  318,  318,  302,  318,  318,
 /*  1660 */   318,  224,  318,  229,   74,   17,  119,  318,   47,   49,
 /*  1670 */   242,  218,  331,  363,  338,   99,  318,  327,  314,  318,
 /*  1680 */   304,   39,  318,  114,  199,  318,  318,  222,  318,  228,
 /*  1690 */    92,  318,  318,  318,  134,  318,  318,  246,  232,  223,
 /*  1700 */   482,  318,   50,  318,  318,  318,  482,  318,  482,  318,
 /*  1710 */   482,  482,  318,  482,  151,  318,   17,  167,  482,   47,
 /*  1720 */    49,  242,  218,  331,  273,  318,   99,   21,   22,  318,
 /*  1730 */   318,  318,  318,  482,    5,  482,  318,  318,  318,  318,
 /*  1740 */   181,   92,  126,  318,  318,  141,  482,  302,  167,  318,
 /*  1750 */   318,  224,  318,  229,   81,  273,  119,  318,   21,   22,
 /*  1760 */   482,  318,  318,  363,  338,  318,  318,  327,  314,  318,
 /*  1770 */   304,  181,  302,  318,  318,  318,  224,  318,  229,   71,
 /*  1780 */   318,  119,  318,  318,  318,  318,  318,  318,  363,  338,
 /*  1790 */   318,  318,  327,  314,  302,  304,  318,  318,  224,  318,
 /*  1800 */   229,   79,  318,  119,  318,  318,  318,  318,  318,  318,
 /*  1810 */   363,  338,  318,  318,  327,  314,  302,  304,  318,  318,
 /*  1820 */   108,  318,  106,   51,  318,  107,  318,  318,  318,  318,
 /*  1830 */   318,  318,  363,  338,  302,  318,  327,  314,  224,  304,
 /*  1840 */   229,   78,  318,  119,  318,  318,  318,  318,  318,  318,
 /*  1850 */   363,  338,  192,  318,  327,  314,  318,  304,  318,  302,
 /*  1860 */   318,  318,  318,  224,  318,  229,   64,  310,  119,  318,
 /*  1870 */   318,  213,  318,   12,  318,  363,  338,  302,  318,  327,
 /*  1880 */   314,  224,  304,  229,   62,  318,  119,  318,  318,  318,
 /*  1890 */   318,  318,  318,  363,  338,  318,  318,  327,  314,  302,
 /*  1900 */   304,    5,  318,  188,  318,  229,   84,  318,  119,  126,
 /*  1910 */   318,  318,  318,  318,  318,  363,  338,  302,  318,  327,
 /*  1920 */   314,  224,  304,  229,   80,  318,  119,  318,  318,  318,
 /*  1930 */   318,  318,  318,  363,  338,  318,  318,  327,  314,  318,
 /*  1940 */   304,  318,  302,  318,  318,  318,  224,  318,  229,   76,
 /*  1950 */   318,  119,  318,  318,  318,  318,  318,  318,  363,  338,
 /*  1960 */   302,  318,  327,  314,  224,  304,  229,   66,  318,  119,
 /*  1970 */   318,  318,  318,  318,  318,  318,  363,  338,  318,  318,
 /*  1980 */   327,  314,  302,  304,  318,  318,  224,  318,  229,   83,
 /*  1990 */   318,  119,  318,  318,  318,  318,  318,  318,  363,  338,
 /*  2000 */   302,  318,  327,  314,  224,  304,  229,   75,  318,  119,
 /*  2010 */   318,  318,  318,  318,  318,  318,  363,  338,  318,  318,
 /*  2020 */   327,  314,  318,  304,  318,  302,  318,  318,  318,  184,
 /*  2030 */   318,  229,   58,  318,  119,  318,  318,  318,  318,  318,
 /*  2040 */   318,  363,  338,  302,  318,  327,  314,  224,  304,  229,
 /*  2050 */    87,  318,  119,  318,  318,  318,  318,  318,  318,  363,
 /*  2060 */   338,  318,  318,  327,  314,  302,  304,  318,  318,  189,
 /*  2070 */   318,  229,   69,  318,  119,  318,  318,  318,  318,  318,
 /*  2080 */   318,  363,  338,  302,  318,  327,  314,  224,  304,  229,
 /*  2090 */    59,  318,  119,  318,  318,  318,  318,  318,  318,  363,
 /*  2100 */   338,  318,  318,  327,  314,  318,  304,  318,  302,  318,
 /*  2110 */   318,  318,  224,  318,  229,   57,  318,  119,  318,  318,
 /*  2120 */   318,  318,  318,  318,  363,  338,  302,  318,  327,  314,
 /*  2130 */   108,  304,  110,   56,  318,  107,  318,  318,  318,  318,
 /*  2140 */   318,  318,  363,  338,  318,  318,  327,  314,  302,  304,
 /*  2150 */   318,  318,  224,  318,  198,   60,  318,  119,  318,  318,
 /*  2160 */   318,  318,  318,  318,  363,  338,  302,  318,  327,  314,
 /*  2170 */   224,  304,  229,   65,  318,  119,  318,  318,  318,  318,
 /*  2180 */   318,  318,  363,  338,  318,  318,  327,  314,  318,  304,
 /*  2190 */   318,  302,  318,  318,  318,  224,  318,  229,   52,  318,
 /*  2200 */   119,  318,  318,  318,  318,  318,  318,  363,  338,  302,
 /*  2210 */   318,  327,  314,  202,  304,  229,   53,  318,  119,  318,
 /*  2220 */   318,  318,  318,  318,  318,  363,  338,  318,  318,  327,
 /*  2230 */   314,  302,  304,  318,  318,  224,  318,  229,   88,  318,
 /*  2240 */   119,  318,  318,  318,  318,  318,  318,  363,  338,  302,
 /*  2250 */   318,  327,  314,  240,  304,  229,  302,  318,  119,  318,
 /*  2260 */   283,  318,  229,  318,  318,  119,  244,  318,  318,  327,
 /*  2270 */   314,  318,  304,  318,  302,  318,  327,  314,  235,  304,
 /*  2280 */   229,  302,  318,  119,  318,  278,  318,  229,  318,  318,
 /*  2290 */   119,  318,  318,  318,  327,  314,  318,  304,  318,  302,
 /*  2300 */   318,  327,  314,  288,  304,  229,  318,  318,  119,  302,
 /*  2310 */   318,  318,  318,  296,  318,  229,  318,  318,  119,  327,
 /*  2320 */   314,  318,  304,  318,  318,  318,  318,  318,  318,  327,
 /*  2330 */   314,  302,  304,  318,  318,  332,  318,  229,  302,  318,
 /*  2340 */   119,  318,  243,  318,  229,  318,  318,  119,  318,  318,
 /*  2350 */   142,  327,  314,  167,  304,  318,  318,  318,  327,  314,
 /*  2360 */   273,  304,  318,   21,   22,  139,  318,  146,  167,  318,
 /*  2370 */   167,  318,  318,  318,  318,  273,  181,  273,   21,   22,
 /*  2380 */    21,   22,  318,  318,  318,  318,  318,  318,  318,  318,
 /*  2390 */   318,  181,  318,  181,
    );
    static public $yy_lookahead = array(
 /*     0 */     1,   81,   82,   83,    3,    4,    5,    6,    7,    8,
 /*    10 */     9,   10,   11,   12,  106,   16,   15,   95,   20,   50,
 /*    20 */    16,   22,   21,   56,   23,   56,   22,   58,   61,   28,
 /*    30 */   108,   62,   31,   32,   35,   36,   37,   38,   39,   40,
 /*    40 */    41,   42,   43,   44,   45,   46,   47,   48,    4,    5,
 /*    50 */     6,    7,    8,   49,   56,   16,   12,   13,   14,   61,
 /*    60 */     1,   22,   63,   64,   65,   66,   67,   68,   69,   70,
 /*    70 */    71,   72,   73,   74,    1,   16,   82,  106,   15,   20,
 /*    80 */    86,   18,   88,   89,   87,   91,   79,   80,   81,   82,
 /*    90 */    83,  114,   98,   99,   97,   22,  102,  103,   15,  105,
 /*   100 */    27,   18,   19,   92,   93,  108,  112,  114,   35,   36,
 /*   110 */    37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
 /*   120 */    47,   48,   59,  110,   15,   87,   16,   18,   90,   19,
 /*   130 */    15,   22,   22,   18,   19,   97,   63,   64,   65,   66,
 /*   140 */    67,   68,   69,   70,   71,   72,   73,   74,    1,    1,
 /*   150 */    82,  113,   87,   30,   86,   90,   88,   89,   15,   91,
 /*   160 */    50,   18,   97,   16,   16,   33,   98,   99,   58,   22,
 /*   170 */   102,  103,   49,  105,   59,   16,   25,  106,  113,  108,
 /*   180 */   112,   22,   35,   36,   37,   38,   39,   40,   41,   42,
 /*   190 */    43,   44,   45,   46,   47,   48,   15,   34,   16,   18,
 /*   200 */    19,   49,   59,   16,   22,   15,   25,   17,   18,   22,
 /*   210 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   220 */    73,   74,    1,   33,   82,   62,   16,   76,   86,   17,
 /*   230 */    88,   89,   22,   91,   92,   15,   49,   16,   18,   82,
 /*   240 */    98,   99,   22,   22,  102,  103,   15,  105,   17,   18,
 /*   250 */    30,   56,  107,   30,  109,  110,   35,   36,   37,   38,
 /*   260 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   270 */     1,   16,   16,   50,   16,  118,  119,   22,   22,   88,
 /*   280 */    22,   58,   91,   25,   63,   64,   65,   66,   67,   68,
 /*   290 */    69,   70,   71,   72,   73,   74,  105,   16,   83,   90,
 /*   300 */    85,   34,   34,   22,   35,   36,   37,   38,   39,   40,
 /*   310 */    41,   42,   43,   44,   45,   46,   47,   48,   51,   51,
 /*   320 */    51,   16,  113,   19,   22,   19,   20,   22,   17,   18,
 /*   330 */    49,   18,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   340 */    71,   72,   73,   74,    1,   82,   87,   90,   60,   86,
 /*   350 */    15,   88,   89,   18,   91,   50,   97,  100,  101,   16,
 /*   360 */    56,   98,   99,   58,   58,  102,  103,  108,  105,   50,
 /*   370 */   113,   60,   59,  109,  110,  112,   34,   58,   35,   36,
 /*   380 */    37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
 /*   390 */    47,   48,    1,   51,   16,   16,   16,  106,   90,  108,
 /*   400 */    22,   22,   22,    1,   25,   15,   63,   64,   65,   66,
 /*   410 */    67,   68,   69,   70,   71,   72,   73,   74,   16,   16,
 /*   420 */    15,  113,   60,   18,   22,   22,   35,   36,   37,   38,
 /*   430 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   440 */    50,   16,   87,   16,   50,   16,   25,   22,   16,   22,
 /*   450 */     2,   22,   97,   62,   63,   64,   65,   66,   67,   68,
 /*   460 */    69,   70,   71,   72,   73,   74,    1,   19,  113,   87,
 /*   470 */    87,   15,   17,   90,   18,   87,   18,   10,   22,   97,
 /*   480 */    97,   49,   15,  100,  101,   97,   30,   16,   21,   24,
 /*   490 */    23,   16,   18,   22,   22,   28,  113,   22,   31,   32,
 /*   500 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   510 */    45,   46,   47,   48,   16,   87,   24,   16,   50,   15,
 /*   520 */    22,   16,   18,   22,   82,   97,   34,   22,   63,   64,
 /*   530 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   540 */     1,  113,   75,   76,   77,   95,   16,   87,   16,   87,
 /*   550 */     1,   10,   22,   87,   22,   16,   15,   97,  108,   97,
 /*   560 */    16,  119,   21,   97,   23,   16,   22,   33,  108,   28,
 /*   570 */   108,   18,   31,   32,   35,   36,   37,   38,   39,   40,
 /*   580 */    41,   42,   43,   44,   45,   46,   47,   48,    1,   87,
 /*   590 */   104,   15,   17,   18,   18,   26,    2,  111,   20,   97,
 /*   600 */     1,   95,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   610 */    71,   72,   73,   74,  108,  113,   75,   76,   77,  109,
 /*   620 */   110,   22,   35,   36,   37,   38,   39,   40,   41,   42,
 /*   630 */    43,   44,   45,   46,   47,   48,   58,   87,   51,  104,
 /*   640 */    15,   18,   16,   18,    2,   18,  111,   97,   22,   17,
 /*   650 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   660 */    73,   74,    1,   82,   18,   95,   17,   86,   95,   88,
 /*   670 */    89,   52,   91,   96,   95,   95,    1,   16,  108,   98,
 /*   680 */    99,  108,   87,  102,  103,  108,  105,  108,  108,   18,
 /*   690 */    18,   16,   97,   62,   18,   17,   35,   36,   37,   38,
 /*   700 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   710 */     1,    2,   97,  113,  107,   20,  106,    1,   17,  108,
 /*   720 */   111,   22,   22,   95,   63,   64,   65,   66,   67,   68,
 /*   730 */    69,   70,   71,   72,   73,   74,  108,   92,   94,    2,
 /*   740 */    22,   94,  106,   13,   35,   36,   37,   38,   39,   40,
 /*   750 */    41,   42,   43,   44,   45,   46,   47,   48,   95,  120,
 /*   760 */   120,   84,  120,  115,  120,  120,  120,  120,  120,  120,
 /*   770 */   120,  108,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   780 */    71,   72,   73,   74,    1,  120,   82,   95,  120,  120,
 /*   790 */    86,  120,   88,   89,  120,   91,  120,  120,  120,  120,
 /*   800 */   108,  120,   98,   99,  120,   22,  102,  103,  120,  105,
 /*   810 */   120,  120,  120,  120,  120,  120,  120,  120,   35,   36,
 /*   820 */    37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
 /*   830 */    47,   48,    1,  120,  120,  120,  120,  120,  120,  120,
 /*   840 */   120,  120,  120,  120,  120,  120,   63,   64,   65,   66,
 /*   850 */    67,   68,   69,   70,   71,   72,   73,   74,  120,  120,
 /*   860 */   120,  120,  120,  120,  120,  120,   35,   36,   37,   38,
 /*   870 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   880 */   120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*   890 */   120,  120,  120,  120,   63,   64,   65,   66,   67,   68,
 /*   900 */    69,   70,   71,   72,   73,   74,    1,   76,   82,  120,
 /*   910 */   120,  120,   86,  120,   88,   89,  120,   91,  120,  120,
 /*   920 */   120,   16,  120,  120,   98,   99,  120,  120,  102,  103,
 /*   930 */   120,  105,  120,  120,  120,  120,  120,  120,  120,  120,
 /*   940 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   950 */    45,   46,   47,   48,    1,  120,  120,  120,  120,  120,
 /*   960 */   120,  120,  120,  120,  120,  120,  120,  120,   63,   64,
 /*   970 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   980 */   120,  120,   29,  120,  120,  120,  120,  120,   35,   36,
 /*   990 */    37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
 /*  1000 */    47,   48,    1,  120,  120,  120,  120,  120,  120,  120,
 /*  1010 */   120,  120,  120,  120,  120,  120,   63,   64,   65,   66,
 /*  1020 */    67,   68,   69,   70,   71,   72,   73,   74,  120,  120,
 /*  1030 */   120,  120,  120,  120,  120,  120,   35,   36,   37,   38,
 /*  1040 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*  1050 */   120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*  1060 */   120,  120,  120,  120,   63,   64,   65,   66,   67,   68,
 /*  1070 */    69,   70,   71,   72,   73,   74,   35,   36,   37,   38,
 /*  1080 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*  1090 */   120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*  1100 */   120,  120,  120,  120,   63,   64,   65,   66,   67,   68,
 /*  1110 */    69,   70,   71,   72,   73,   74,  120,  120,  120,  120,
 /*  1120 */    15,  120,   17,   18,  120,   82,   21,  120,   23,   86,
 /*  1130 */   120,   88,  120,   28,   91,  120,   31,   32,   33,  120,
 /*  1140 */   120,   36,   99,   16,  120,  102,  103,  120,  105,   22,
 /*  1150 */   120,  120,  120,  120,  120,   50,   29,  120,   53,   54,
 /*  1160 */    55,   56,   57,  120,  120,   60,   61,   62,  120,  120,
 /*  1170 */   120,   15,  120,   17,   18,  120,   49,   21,  120,   23,
 /*  1180 */    75,  120,  120,  120,   28,  120,  120,   31,   32,   33,
 /*  1190 */   120,  120,   36,  120,  120,  120,  120,  120,   82,  120,
 /*  1200 */   120,  120,   86,  120,   88,   89,   50,   91,  120,   53,
 /*  1210 */    54,   55,   56,   57,   98,   99,   60,   61,  102,  103,
 /*  1220 */   120,  105,   15,  120,   17,   18,  120,  120,   21,  120,
 /*  1230 */    23,   75,  116,  117,  120,   28,  120,  120,   31,   32,
 /*  1240 */    33,  120,  120,   36,  120,  120,  120,  120,  120,   82,
 /*  1250 */   120,  120,  120,   86,  120,   88,   89,   50,   91,  120,
 /*  1260 */    53,   54,   55,   56,   57,   98,   99,   60,   61,  102,
 /*  1270 */   103,  120,  105,   15,  120,   17,   18,  120,  120,   21,
 /*  1280 */   120,   23,   75,  120,  117,  120,   28,  120,  120,   31,
 /*  1290 */    32,   33,  120,  120,   36,  120,  120,  120,  120,  120,
 /*  1300 */    82,  120,  120,  120,   86,  120,   88,   89,   50,   91,
 /*  1310 */   120,   53,   54,   55,   56,   57,   98,   99,   60,   61,
 /*  1320 */   102,  103,  120,  105,   15,  120,   17,   18,  120,  120,
 /*  1330 */    21,  120,   23,   75,  120,  120,  120,   28,  120,  120,
 /*  1340 */    31,   32,   33,  120,  120,   36,  120,  120,  120,  120,
 /*  1350 */   120,   82,  120,  120,  120,   86,  120,   88,   89,   50,
 /*  1360 */    91,  120,   53,   54,   55,   56,   57,   98,   99,   60,
 /*  1370 */    61,  102,  103,  120,  105,   15,  120,   17,   18,  120,
 /*  1380 */   120,   21,  120,   23,   75,  120,  120,  120,   28,  120,
 /*  1390 */   120,   31,   32,   33,  120,  120,   36,  120,  120,  120,
 /*  1400 */   120,  120,   82,  120,  120,  120,   86,  120,   88,   89,
 /*  1410 */    50,   91,  120,   53,   54,   55,   56,   57,   98,   99,
 /*  1420 */    60,   61,  102,  103,  120,  105,   15,  120,   17,   18,
 /*  1430 */   120,  120,   21,  120,   23,   75,  120,  120,  120,   28,
 /*  1440 */   120,  120,   31,   32,   33,  120,  120,   36,  120,  120,
 /*  1450 */   120,  120,  120,   82,  120,  120,  120,   86,  120,   88,
 /*  1460 */    89,   50,   91,  120,   53,   54,   55,   56,   57,   98,
 /*  1470 */    99,   60,   61,  102,  103,  120,  105,   15,  120,   17,
 /*  1480 */    18,  120,  120,   21,  120,   23,   75,  120,  120,  120,
 /*  1490 */    28,  120,  120,   31,   32,   33,  120,  120,   36,  120,
 /*  1500 */   120,  120,  120,  120,   82,  120,  120,  120,   86,  120,
 /*  1510 */    88,   89,   50,   91,  120,   53,   54,   55,   56,   57,
 /*  1520 */    98,   99,   60,   61,  102,  103,  120,  105,   15,  120,
 /*  1530 */    17,   18,  120,  120,   21,  120,   23,   75,  120,  120,
 /*  1540 */   120,   28,  120,  120,   31,   32,   33,  120,  120,   36,
 /*  1550 */   120,  120,  120,  120,  120,   82,  120,  120,  120,   86,
 /*  1560 */   120,   88,   89,   50,   91,  120,   53,   54,   55,   56,
 /*  1570 */    57,   98,   99,   60,   61,  102,  103,  120,  105,   15,
 /*  1580 */   120,   17,   18,  120,  120,   21,  120,   23,   75,  120,
 /*  1590 */   120,  120,   28,  120,  120,   31,   32,   33,  120,  120,
 /*  1600 */    36,  120,  120,  120,  120,  120,   82,  120,  120,  120,
 /*  1610 */    86,  120,   88,   89,   50,   91,  120,   53,   54,   55,
 /*  1620 */    56,   57,   98,   99,   60,   61,  102,  103,  120,  105,
 /*  1630 */    15,  120,   17,   18,  120,  120,   21,  120,   23,   75,
 /*  1640 */   120,  120,  120,   28,  120,  120,   31,   32,   33,  120,
 /*  1650 */   120,   36,  120,  120,  120,  120,  120,   82,  120,  120,
 /*  1660 */   120,   86,  120,   88,   89,   50,   91,  120,   53,   54,
 /*  1670 */    55,   56,   57,   98,   99,   60,  120,  102,  103,  120,
 /*  1680 */   105,   15,  120,   17,   18,  120,  120,   21,  120,   23,
 /*  1690 */    75,  120,  120,  120,   28,  120,  120,   31,   32,   33,
 /*  1700 */    16,  120,   36,  120,  120,  120,   22,  120,   24,  120,
 /*  1710 */    26,   27,  120,   29,   87,  120,   50,   90,   34,   53,
 /*  1720 */    54,   55,   56,   57,   97,  120,   60,  100,  101,  120,
 /*  1730 */   120,  120,  120,   49,   50,   51,  120,  120,  120,  120,
 /*  1740 */   113,   75,   58,  120,  120,   87,   62,   82,   90,  120,
 /*  1750 */   120,   86,  120,   88,   89,   97,   91,  120,  100,  101,
 /*  1760 */    76,  120,  120,   98,   99,  120,  120,  102,  103,  120,
 /*  1770 */   105,  113,   82,  120,  120,  120,   86,  120,   88,   89,
 /*  1780 */   120,   91,  120,  120,  120,  120,  120,  120,   98,   99,
 /*  1790 */   120,  120,  102,  103,   82,  105,  120,  120,   86,  120,
 /*  1800 */    88,   89,  120,   91,  120,  120,  120,  120,  120,  120,
 /*  1810 */    98,   99,  120,  120,  102,  103,   82,  105,  120,  120,
 /*  1820 */    86,  120,   88,   89,  120,   91,  120,  120,  120,  120,
 /*  1830 */   120,  120,   98,   99,   82,  120,  102,  103,   86,  105,
 /*  1840 */    88,   89,  120,   91,  120,  120,  120,  120,  120,  120,
 /*  1850 */    98,   99,    1,  120,  102,  103,  120,  105,  120,   82,
 /*  1860 */   120,  120,  120,   86,  120,   88,   89,   16,   91,  120,
 /*  1870 */   120,   20,  120,   22,  120,   98,   99,   82,  120,  102,
 /*  1880 */   103,   86,  105,   88,   89,  120,   91,  120,  120,  120,
 /*  1890 */   120,  120,  120,   98,   99,  120,  120,  102,  103,   82,
 /*  1900 */   105,   50,  120,   86,  120,   88,   89,  120,   91,   58,
 /*  1910 */   120,  120,  120,  120,  120,   98,   99,   82,  120,  102,
 /*  1920 */   103,   86,  105,   88,   89,  120,   91,  120,  120,  120,
 /*  1930 */   120,  120,  120,   98,   99,  120,  120,  102,  103,  120,
 /*  1940 */   105,  120,   82,  120,  120,  120,   86,  120,   88,   89,
 /*  1950 */   120,   91,  120,  120,  120,  120,  120,  120,   98,   99,
 /*  1960 */    82,  120,  102,  103,   86,  105,   88,   89,  120,   91,
 /*  1970 */   120,  120,  120,  120,  120,  120,   98,   99,  120,  120,
 /*  1980 */   102,  103,   82,  105,  120,  120,   86,  120,   88,   89,
 /*  1990 */   120,   91,  120,  120,  120,  120,  120,  120,   98,   99,
 /*  2000 */    82,  120,  102,  103,   86,  105,   88,   89,  120,   91,
 /*  2010 */   120,  120,  120,  120,  120,  120,   98,   99,  120,  120,
 /*  2020 */   102,  103,  120,  105,  120,   82,  120,  120,  120,   86,
 /*  2030 */   120,   88,   89,  120,   91,  120,  120,  120,  120,  120,
 /*  2040 */   120,   98,   99,   82,  120,  102,  103,   86,  105,   88,
 /*  2050 */    89,  120,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2060 */    99,  120,  120,  102,  103,   82,  105,  120,  120,   86,
 /*  2070 */   120,   88,   89,  120,   91,  120,  120,  120,  120,  120,
 /*  2080 */   120,   98,   99,   82,  120,  102,  103,   86,  105,   88,
 /*  2090 */    89,  120,   91,  120,  120,  120,  120,  120,  120,   98,
 /*  2100 */    99,  120,  120,  102,  103,  120,  105,  120,   82,  120,
 /*  2110 */   120,  120,   86,  120,   88,   89,  120,   91,  120,  120,
 /*  2120 */   120,  120,  120,  120,   98,   99,   82,  120,  102,  103,
 /*  2130 */    86,  105,   88,   89,  120,   91,  120,  120,  120,  120,
 /*  2140 */   120,  120,   98,   99,  120,  120,  102,  103,   82,  105,
 /*  2150 */   120,  120,   86,  120,   88,   89,  120,   91,  120,  120,
 /*  2160 */   120,  120,  120,  120,   98,   99,   82,  120,  102,  103,
 /*  2170 */    86,  105,   88,   89,  120,   91,  120,  120,  120,  120,
 /*  2180 */   120,  120,   98,   99,  120,  120,  102,  103,  120,  105,
 /*  2190 */   120,   82,  120,  120,  120,   86,  120,   88,   89,  120,
 /*  2200 */    91,  120,  120,  120,  120,  120,  120,   98,   99,   82,
 /*  2210 */   120,  102,  103,   86,  105,   88,   89,  120,   91,  120,
 /*  2220 */   120,  120,  120,  120,  120,   98,   99,  120,  120,  102,
 /*  2230 */   103,   82,  105,  120,  120,   86,  120,   88,   89,  120,
 /*  2240 */    91,  120,  120,  120,  120,  120,  120,   98,   99,   82,
 /*  2250 */   120,  102,  103,   86,  105,   88,   82,  120,   91,  120,
 /*  2260 */    86,  120,   88,  120,  120,   91,   99,  120,  120,  102,
 /*  2270 */   103,  120,  105,  120,   82,  120,  102,  103,   86,  105,
 /*  2280 */    88,   82,  120,   91,  120,   86,  120,   88,  120,  120,
 /*  2290 */    91,  120,  120,  120,  102,  103,  120,  105,  120,   82,
 /*  2300 */   120,  102,  103,   86,  105,   88,  120,  120,   91,   82,
 /*  2310 */   120,  120,  120,   86,  120,   88,  120,  120,   91,  102,
 /*  2320 */   103,  120,  105,  120,  120,  120,  120,  120,  120,  102,
 /*  2330 */   103,   82,  105,  120,  120,   86,  120,   88,   82,  120,
 /*  2340 */    91,  120,   86,  120,   88,  120,  120,   91,  120,  120,
 /*  2350 */    87,  102,  103,   90,  105,  120,  120,  120,  102,  103,
 /*  2360 */    97,  105,  120,  100,  101,   87,  120,   87,   90,  120,
 /*  2370 */    90,  120,  120,  120,  120,   97,  113,   97,  100,  101,
 /*  2380 */   100,  101,  120,  120,  120,  120,  120,  120,  120,  120,
 /*  2390 */   120,  113,  120,  113,
);
    const YY_SHIFT_USE_DFLT = -34;
    const YY_SHIFT_MAX = 233;
    static public $yy_shift_ofst = array(
 /*     0 */     1, 1309, 1309, 1156, 1360, 1156, 1156, 1105, 1156, 1156,
 /*    10 */  1156, 1462, 1513, 1156, 1156, 1564, 1156, 1156, 1156, 1156,
 /*    20 */  1513, 1156, 1156, 1411, 1156, 1156, 1156, 1156, 1156, 1156,
 /*    30 */  1156, 1156, 1156, 1156, 1207, 1156, 1156, 1156, 1156, 1411,
 /*    40 */  1156, 1156, 1258, 1258, 1666, 1666, 1615, 1666, 1666, 1666,
 /*    50 */  1666,  221,   73,  147,   -1,  783,  783,  783,  953,  905,
 /*    60 */   831,  539,  709,  343,  269,  391,  661,  587,  465, 1001,
 /*    70 */  1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001,
 /*    80 */  1001, 1001, 1001, 1001, 1001, 1001, 1001, 1041, 1041, 1851,
 /*    90 */   599,    1,  541,  456,  220,   -2,  109,  402,  109,  311,
 /*   100 */   599,  599,  467,   44,  115,  181,  379,  306,    4,  143,
 /*   110 */   258,   59,  335,  335,  335,  405,  675,  576,  335,  578,
 /*   120 */   335,  575,  335,  335,  504,  405,  575,  626,  625,  335,
 /*   130 */   335,  695,  695,  701,  699,  700,   63,   83,  231,  425,
 /*   140 */   427,  475,  403,  471,  429,  -33,  256,  182,  159,   39,
 /*   150 */   210,  380,  255,  -33,  390,  -33,  148,  -33,  532,  530,
 /*   160 */   505,  501,  544,  -33,  549,  378,  498,  716,  730,  695,
 /*   170 */   695,  468,  718,  718,  701,  737,  737,  695,  -34,  -34,
 /*   180 */   -34,  -34, 1684,  110, 1127,  190,  -31,  305,  187,  281,
 /*   190 */   223,  304,  313,  123,  448,  268,  492,  267,  151,  319,
 /*   200 */   163,  342,  432,  319,  678,  642,  632,  594,  627,  132,
 /*   210 */   623,  646,  649,  676,  672,  671,  619,  631,  534,  553,
 /*   220 */   288,  362,  302,  195,  152,  212,  394,  468,  472,  421,
 /*   230 */   569,  458,  474,  455,
);
    const YY_REDUCE_USE_DFLT = -93;
    const YY_REDUCE_MAX = 181;
    static public $yy_reduce_ofst = array(
 /*     0 */     7, 1116, 1167,  263,  142,   68,   -6, 2084, 1575, 1218,
 /*    10 */  1320, 1961, 1817, 1473, 1835, 1795, 1752, 1777, 1860, 1878,
 /*    20 */  1943, 1918, 1900, 1734, 1712, 1269,  704,  826, 1371, 1422,
 /*    30 */  1690, 1665, 2001, 1524, 1983, 2149, 2109, 2066, 2127, 2044,
 /*    40 */  2026,  581, 2167, 1043, 2249, 2199, 2192, 2174, 2256, 2227,
 /*    50 */  2217,  383, 1658, 1627, 2263, 2278,  383, 2280,  257,  257,
 /*    60 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*    70 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*    80 */   257,  257,  257,  257,  257,  257,  257,  257,  257,   38,
 /*    90 */    65,  -80,  157,  259,  460,  145,   -3,  428,  462,  191,
 /*   100 */   355,  502,  442,  215,  291,  577,  466,  264,  550,  291,
 /*   110 */   466,  209,  573,  450,  580,  580,  308,  580,  628,  264,
 /*   120 */   663,  486,  506,  570,  579,  692,  535,  595,  580,   71,
 /*   130 */   -78,  264,  510,   11,  388,  382,  611,  611,  609,  615,
 /*   140 */   615,  615,  615,  615,  615,  607,  615,  615,  615,  615,
 /*   150 */   615,  615,  615,  607,  610,  607,  600,  607,  615,  615,
 /*   160 */   615,  615,  615,  607,  600,  615,  615,  600,  677,   13,
 /*   170 */    13,  636,  644,  647,  645,  648,  648,   13,  -29,  -92,
 /*   180 */   -23,   -7,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 21, 23, 28, 31, 32, ),
        /* 1 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 2 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 3 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 4 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 5 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 6 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 7 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 62, 75, ),
        /* 8 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 9 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 10 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 11 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 12 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 13 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 14 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 15 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 16 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 17 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 18 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 19 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 20 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 21 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 22 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 23 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 24 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 25 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 26 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 27 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 28 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 29 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 30 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 31 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 32 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 33 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 34 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 35 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 36 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 37 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 38 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 39 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 40 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 41 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 42 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 43 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 44 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 75, ),
        /* 45 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 75, ),
        /* 46 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 75, ),
        /* 47 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 75, ),
        /* 48 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 75, ),
        /* 49 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 75, ),
        /* 50 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 75, ),
        /* 51 */ array(1, 16, 22, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 52 */ array(1, 22, 27, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 53 */ array(1, 16, 22, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 54 */ array(1, 16, 22, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 55 */ array(1, 22, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 56 */ array(1, 22, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 57 */ array(1, 22, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 58 */ array(1, 29, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 59 */ array(1, 16, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 60 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 76, ),
        /* 61 */ array(1, 16, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 62 */ array(1, 2, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 63 */ array(1, 16, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 64 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 51, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 65 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 66 */ array(1, 16, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 67 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 51, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 68 */ array(1, 24, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 69 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 70 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 71 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 72 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 73 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 74 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 75 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 76 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 77 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 78 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 79 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 80 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 81 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 82 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 83 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 84 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 85 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 86 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 87 */ array(35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 88 */ array(35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 89 */ array(1, 16, 20, 22, 50, 58, ),
        /* 90 */ array(1, 22, ),
        /* 91 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 21, 23, 28, 31, 32, ),
        /* 92 */ array(10, 15, 21, 23, 28, 31, 32, 75, 76, 77, ),
        /* 93 */ array(15, 18, 22, 30, ),
        /* 94 */ array(15, 18, 22, 30, ),
        /* 95 */ array(20, 56, 61, ),
        /* 96 */ array(15, 18, 22, ),
        /* 97 */ array(1, 16, 22, ),
        /* 98 */ array(15, 18, 22, ),
        /* 99 */ array(17, 18, 60, ),
        /* 100 */ array(1, 22, ),
        /* 101 */ array(1, 22, ),
        /* 102 */ array(10, 15, 21, 23, 28, 31, 32, 75, 76, 77, ),
        /* 103 */ array(4, 5, 6, 7, 8, 12, 13, 14, ),
        /* 104 */ array(15, 18, 19, 59, ),
        /* 105 */ array(15, 18, 19, 25, ),
        /* 106 */ array(16, 22, 25, ),
        /* 107 */ array(19, 20, 58, ),
        /* 108 */ array(16, 22, 49, ),
        /* 109 */ array(15, 18, 59, ),
        /* 110 */ array(16, 22, 25, ),
        /* 111 */ array(1, 16, 20, ),
        /* 112 */ array(15, 18, ),
        /* 113 */ array(15, 18, ),
        /* 114 */ array(15, 18, ),
        /* 115 */ array(15, 18, ),
        /* 116 */ array(1, 16, ),
        /* 117 */ array(15, 18, ),
        /* 118 */ array(15, 18, ),
        /* 119 */ array(20, 58, ),
        /* 120 */ array(15, 18, ),
        /* 121 */ array(17, 18, ),
        /* 122 */ array(15, 18, ),
        /* 123 */ array(15, 18, ),
        /* 124 */ array(15, 18, ),
        /* 125 */ array(15, 18, ),
        /* 126 */ array(17, 18, ),
        /* 127 */ array(16, 22, ),
        /* 128 */ array(15, 18, ),
        /* 129 */ array(15, 18, ),
        /* 130 */ array(15, 18, ),
        /* 131 */ array(20, ),
        /* 132 */ array(20, ),
        /* 133 */ array(17, ),
        /* 134 */ array(22, ),
        /* 135 */ array(22, ),
        /* 136 */ array(15, 18, 59, ),
        /* 137 */ array(15, 18, 19, ),
        /* 138 */ array(15, 17, 18, ),
        /* 139 */ array(16, 22, ),
        /* 140 */ array(16, 22, ),
        /* 141 */ array(16, 22, ),
        /* 142 */ array(16, 22, ),
        /* 143 */ array(16, 22, ),
        /* 144 */ array(16, 22, ),
        /* 145 */ array(56, 61, ),
        /* 146 */ array(16, 22, ),
        /* 147 */ array(16, 22, ),
        /* 148 */ array(16, 22, ),
        /* 149 */ array(16, 22, ),
        /* 150 */ array(16, 22, ),
        /* 151 */ array(16, 22, ),
        /* 152 */ array(16, 22, ),
        /* 153 */ array(56, 61, ),
        /* 154 */ array(15, 50, ),
        /* 155 */ array(56, 61, ),
        /* 156 */ array(1, 16, ),
        /* 157 */ array(56, 61, ),
        /* 158 */ array(16, 22, ),
        /* 159 */ array(16, 22, ),
        /* 160 */ array(16, 22, ),
        /* 161 */ array(16, 22, ),
        /* 162 */ array(16, 22, ),
        /* 163 */ array(56, 61, ),
        /* 164 */ array(1, 16, ),
        /* 165 */ array(16, 22, ),
        /* 166 */ array(16, 22, ),
        /* 167 */ array(1, ),
        /* 168 */ array(13, ),
        /* 169 */ array(20, ),
        /* 170 */ array(20, ),
        /* 171 */ array(50, ),
        /* 172 */ array(22, ),
        /* 173 */ array(22, ),
        /* 174 */ array(17, ),
        /* 175 */ array(2, ),
        /* 176 */ array(2, ),
        /* 177 */ array(20, ),
        /* 178 */ array(),
        /* 179 */ array(),
        /* 180 */ array(),
        /* 181 */ array(),
        /* 182 */ array(16, 22, 24, 26, 27, 29, 34, 49, 50, 51, 58, 62, 76, ),
        /* 183 */ array(16, 19, 22, 50, 58, ),
        /* 184 */ array(16, 22, 29, 49, ),
        /* 185 */ array(15, 17, 18, 33, ),
        /* 186 */ array(50, 56, 58, 62, ),
        /* 187 */ array(16, 22, 50, 58, ),
        /* 188 */ array(16, 22, 49, ),
        /* 189 */ array(16, 22, 49, ),
        /* 190 */ array(30, 50, 58, ),
        /* 191 */ array(19, 56, ),
        /* 192 */ array(18, 59, ),
        /* 193 */ array(30, 49, ),
        /* 194 */ array(2, 19, ),
        /* 195 */ array(34, 51, ),
        /* 196 */ array(24, 34, ),
        /* 197 */ array(34, 51, ),
        /* 198 */ array(25, 76, ),
        /* 199 */ array(50, 58, ),
        /* 200 */ array(34, 62, ),
        /* 201 */ array(34, 51, ),
        /* 202 */ array(16, 49, ),
        /* 203 */ array(50, 58, ),
        /* 204 */ array(17, ),
        /* 205 */ array(2, ),
        /* 206 */ array(17, ),
        /* 207 */ array(2, ),
        /* 208 */ array(18, ),
        /* 209 */ array(33, ),
        /* 210 */ array(18, ),
        /* 211 */ array(18, ),
        /* 212 */ array(17, ),
        /* 213 */ array(18, ),
        /* 214 */ array(18, ),
        /* 215 */ array(18, ),
        /* 216 */ array(52, ),
        /* 217 */ array(62, ),
        /* 218 */ array(33, ),
        /* 219 */ array(18, ),
        /* 220 */ array(60, ),
        /* 221 */ array(60, ),
        /* 222 */ array(22, ),
        /* 223 */ array(56, ),
        /* 224 */ array(49, ),
        /* 225 */ array(17, ),
        /* 226 */ array(50, ),
        /* 227 */ array(50, ),
        /* 228 */ array(22, ),
        /* 229 */ array(25, ),
        /* 230 */ array(26, ),
        /* 231 */ array(18, ),
        /* 232 */ array(18, ),
        /* 233 */ array(17, ),
        /* 234 */ array(),
        /* 235 */ array(),
        /* 236 */ array(),
        /* 237 */ array(),
        /* 238 */ array(),
        /* 239 */ array(),
        /* 240 */ array(),
        /* 241 */ array(),
        /* 242 */ array(),
        /* 243 */ array(),
        /* 244 */ array(),
        /* 245 */ array(),
        /* 246 */ array(),
        /* 247 */ array(),
        /* 248 */ array(),
        /* 249 */ array(),
        /* 250 */ array(),
        /* 251 */ array(),
        /* 252 */ array(),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
        /* 314 */ array(),
        /* 315 */ array(),
        /* 316 */ array(),
        /* 317 */ array(),
        /* 318 */ array(),
        /* 319 */ array(),
        /* 320 */ array(),
        /* 321 */ array(),
        /* 322 */ array(),
        /* 323 */ array(),
        /* 324 */ array(),
        /* 325 */ array(),
        /* 326 */ array(),
        /* 327 */ array(),
        /* 328 */ array(),
        /* 329 */ array(),
        /* 330 */ array(),
        /* 331 */ array(),
        /* 332 */ array(),
        /* 333 */ array(),
        /* 334 */ array(),
        /* 335 */ array(),
        /* 336 */ array(),
        /* 337 */ array(),
        /* 338 */ array(),
        /* 339 */ array(),
        /* 340 */ array(),
        /* 341 */ array(),
        /* 342 */ array(),
        /* 343 */ array(),
        /* 344 */ array(),
        /* 345 */ array(),
        /* 346 */ array(),
        /* 347 */ array(),
        /* 348 */ array(),
        /* 349 */ array(),
        /* 350 */ array(),
        /* 351 */ array(),
        /* 352 */ array(),
        /* 353 */ array(),
        /* 354 */ array(),
        /* 355 */ array(),
        /* 356 */ array(),
        /* 357 */ array(),
        /* 358 */ array(),
        /* 359 */ array(),
        /* 360 */ array(),
        /* 361 */ array(),
        /* 362 */ array(),
        /* 363 */ array(),
        /* 364 */ array(),
        /* 365 */ array(),
        /* 366 */ array(),
        /* 367 */ array(),
        /* 368 */ array(),
        /* 369 */ array(),
        /* 370 */ array(),
        /* 371 */ array(),
        /* 372 */ array(),
        /* 373 */ array(),
);
    static public $yy_default = array(
 /*     0 */   377,  553,  570,  524,  570,  524,  524,  570,  570,  570,
 /*    10 */   570,  570,  570,  570,  570,  570,  570,  570,  570,  570,
 /*    20 */   570,  570,  570,  570,  570,  570,  570,  570,  570,  570,
 /*    30 */   570,  570,  570,  570,  570,  570,  570,  570,  570,  570,
 /*    40 */   570,  570,  570,  570,  570,  570,  570,  570,  570,  570,
 /*    50 */   570,  570,  435,  570,  570,  435,  435,  435,  440,  570,
 /*    60 */   570,  570,  570,  570,  570,  570,  570,  570,  570,  437,
 /*    70 */   442,  445,  523,  522,  554,  454,  419,  467,  462,  459,
 /*    80 */   466,  555,  458,  457,  440,  556,  463,  470,  471,  482,
 /*    90 */   435,  374,  570,  435,  435,  536,  435,  453,  435,  570,
 /*   100 */   435,  435,  570,  570,  497,  570,  472,  490,  446,  497,
 /*   110 */   472,  570,  570,  570,  570,  570,  570,  570,  570,  490,
 /*   120 */   570,  570,  570,  570,  570,  570,  570,  570,  570,  497,
 /*   130 */   570,  490,  533,  570,  435,  435,  498,  570,  570,  570,
 /*   140 */   570,  570,  570,  570,  570,  515,  570,  570,  570,  570,
 /*   150 */   570,  570,  570,  514,  497,  517,  570,  516,  570,  570,
 /*   160 */   570,  570,  570,  495,  570,  570,  570,  453,  392,  534,
 /*   170 */   537,  497,  569,  569,  570,  526,  525,  511,  497,  497,
 /*   180 */   530,  530,  448,  482,  446,  570,  482,  482,  446,  446,
 /*   190 */   482,  478,  570,  446,  509,  570,  570,  570,  472,  482,
 /*   200 */   570,  570,  446,  468,  570,  509,  570,  509,  570,  480,
 /*   210 */   570,  570,  570,  570,  570,  570,  484,  570,  570,  570,
 /*   220 */   570,  570,  570,  478,  446,  570,  535,  509,  570,  472,
 /*   230 */   443,  570,  570,  570,  519,  469,  416,  509,  417,  542,
 /*   240 */   531,  422,  477,  449,  532,  543,  428,  520,  484,  376,
 /*   250 */   461,  503,  375,  505,  546,  460,  425,  544,  431,  508,
 /*   260 */   545,  504,  506,  502,  432,  529,  538,  464,  539,  384,
 /*   270 */   381,  540,  383,  434,  430,  444,  568,  382,  450,  420,
 /*   280 */   427,  424,  378,  474,  385,  510,  465,  386,  473,  541,
 /*   290 */   429,  380,  421,  476,  426,  379,  475,  547,  398,  406,
 /*   300 */   499,  405,  489,  507,  492,  399,  407,  397,  414,  409,
 /*   310 */   410,  496,  512,  396,  486,  408,  565,  404,  513,  456,
 /*   320 */   400,  455,  528,  433,  527,  401,  418,  483,  501,  403,
 /*   330 */   500,  485,  451,  402,  564,  491,  411,  487,  452,  521,
 /*   340 */   390,  551,  550,  391,  552,  549,  481,  493,  494,  388,
 /*   350 */   479,  518,  389,  548,  415,  393,  423,  558,  559,  557,
 /*   360 */   412,  448,  413,  447,  395,  394,  567,  560,  488,  566,
 /*   370 */   563,  562,  561,  387,
);
    const YYNOCODE = 121;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 374;
    const YYNRULE = 196;
    const YYERRORSYMBOL = 78;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    static public $yyFallback = array(
    );
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    static public $yyTraceFILE;
    static public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array( 
  '$',             'VERT',          'COLON',         'COMMENT',     
  'PHPSTARTTAG',   'PHPENDTAG',     'ASPSTARTTAG',   'ASPENDTAG',   
  'FAKEPHPSTARTTAG',  'XMLTAG',        'OTHER',         'LINEBREAK',   
  'LITERALSTART',  'LITERALEND',    'LITERAL',       'LDEL',        
  'RDEL',          'DOLLAR',        'ID',            'EQUAL',       
  'PTR',           'LDELIF',        'SPACE',         'LDELFOR',     
  'SEMICOLON',     'INCDEC',        'TO',            'STEP',        
  'LDELFOREACH',   'AS',            'APTR',          'SMARTYBLOCKCHILD',
  'LDELSLASH',     'INTEGER',       'COMMA',         'MATH',        
  'UNIMATH',       'ANDSYM',        'ISIN',          'ISDIVBY',     
  'ISNOTDIVBY',    'ISEVEN',        'ISNOTEVEN',     'ISEVENBY',    
  'ISNOTEVENBY',   'ISODD',         'ISNOTODD',      'ISODDBY',     
  'ISNOTODDBY',    'INSTANCEOF',    'OPENP',         'CLOSEP',      
  'QMARK',         'NOT',           'TYPECAST',      'HEX',         
  'DOT',           'SINGLEQUOTESTRING',  'DOUBLECOLON',   'AT',          
  'HATCH',         'OPENB',         'CLOSEB',        'EQUALS',      
  'NOTEQUALS',     'GREATERTHAN',   'LESSTHAN',      'GREATEREQUAL',
  'LESSEQUAL',     'IDENTITY',      'NONEIDENTITY',  'MOD',         
  'LAND',          'LOR',           'LXOR',          'QUOTE',       
  'BACKTICK',      'DOLLARID',      'error',         'start',       
  'template',      'template_element',  'smartytag',     'literal',     
  'literal_elements',  'literal_element',  'value',         'attributes',  
  'variable',      'expr',          'modifierlist',  'varindexed',  
  'statement',     'statements',    'optspace',      'varvar',      
  'foraction',     'attribute',     'ternary',       'array',       
  'ifcond',        'lop',           'function',      'doublequoted_with_quotes',
  'static_class_access',  'object',        'arrayindex',    'indexdef',    
  'varvarele',     'objectchain',   'objectelement',  'method',      
  'params',        'modifier',      'modparameters',  'modparameter',
  'arrayelements',  'arrayelement',  'doublequoted',  'doublequotedcontent',
    );

    static public $yyRuleName = array(
 /*   0 */ "start ::= template",
 /*   1 */ "template ::= template_element",
 /*   2 */ "template ::= template template_element",
 /*   3 */ "template ::=",
 /*   4 */ "template_element ::= smartytag",
 /*   5 */ "template_element ::= COMMENT",
 /*   6 */ "template_element ::= literal",
 /*   7 */ "template_element ::= PHPSTARTTAG",
 /*   8 */ "template_element ::= PHPENDTAG",
 /*   9 */ "template_element ::= ASPSTARTTAG",
 /*  10 */ "template_element ::= ASPENDTAG",
 /*  11 */ "template_element ::= FAKEPHPSTARTTAG",
 /*  12 */ "template_element ::= XMLTAG",
 /*  13 */ "template_element ::= OTHER",
 /*  14 */ "template_element ::= LINEBREAK",
 /*  15 */ "literal ::= LITERALSTART LITERALEND",
 /*  16 */ "literal ::= LITERALSTART literal_elements LITERALEND",
 /*  17 */ "literal_elements ::= literal_elements literal_element",
 /*  18 */ "literal_elements ::=",
 /*  19 */ "literal_element ::= literal",
 /*  20 */ "literal_element ::= LITERAL",
 /*  21 */ "literal_element ::= PHPSTARTTAG",
 /*  22 */ "literal_element ::= FAKEPHPSTARTTAG",
 /*  23 */ "literal_element ::= PHPENDTAG",
 /*  24 */ "literal_element ::= ASPSTARTTAG",
 /*  25 */ "literal_element ::= ASPENDTAG",
 /*  26 */ "smartytag ::= LDEL value RDEL",
 /*  27 */ "smartytag ::= LDEL value attributes RDEL",
 /*  28 */ "smartytag ::= LDEL variable attributes RDEL",
 /*  29 */ "smartytag ::= LDEL expr modifierlist attributes RDEL",
 /*  30 */ "smartytag ::= LDEL expr attributes RDEL",
 /*  31 */ "smartytag ::= LDEL DOLLAR ID EQUAL value RDEL",
 /*  32 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr RDEL",
 /*  33 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr attributes RDEL",
 /*  34 */ "smartytag ::= LDEL varindexed EQUAL expr attributes RDEL",
 /*  35 */ "smartytag ::= LDEL ID attributes RDEL",
 /*  36 */ "smartytag ::= LDEL ID RDEL",
 /*  37 */ "smartytag ::= LDEL ID PTR ID attributes RDEL",
 /*  38 */ "smartytag ::= LDEL ID modifierlist attributes RDEL",
 /*  39 */ "smartytag ::= LDEL ID PTR ID modifierlist attributes RDEL",
 /*  40 */ "smartytag ::= LDELIF SPACE expr RDEL",
 /*  41 */ "smartytag ::= LDELIF SPACE expr attributes RDEL",
 /*  42 */ "smartytag ::= LDELIF SPACE statement RDEL",
 /*  43 */ "smartytag ::= LDELIF SPACE statement attributes RDEL",
 /*  44 */ "smartytag ::= LDELFOR SPACE statements SEMICOLON optspace expr SEMICOLON optspace DOLLAR varvar foraction attributes RDEL",
 /*  45 */ "foraction ::= EQUAL expr",
 /*  46 */ "foraction ::= INCDEC",
 /*  47 */ "smartytag ::= LDELFOR SPACE statement TO expr attributes RDEL",
 /*  48 */ "smartytag ::= LDELFOR SPACE statement TO expr STEP expr attributes RDEL",
 /*  49 */ "smartytag ::= LDELFOREACH attributes RDEL",
 /*  50 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar attributes RDEL",
 /*  51 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar APTR DOLLAR varvar attributes RDEL",
 /*  52 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar attributes RDEL",
 /*  53 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar APTR DOLLAR varvar attributes RDEL",
 /*  54 */ "smartytag ::= SMARTYBLOCKCHILD",
 /*  55 */ "smartytag ::= LDELSLASH ID RDEL",
 /*  56 */ "smartytag ::= LDELSLASH ID modifierlist RDEL",
 /*  57 */ "smartytag ::= LDELSLASH ID PTR ID RDEL",
 /*  58 */ "smartytag ::= LDELSLASH ID PTR ID modifierlist RDEL",
 /*  59 */ "attributes ::= attributes attribute",
 /*  60 */ "attributes ::= attribute",
 /*  61 */ "attributes ::=",
 /*  62 */ "attribute ::= SPACE ID EQUAL ID",
 /*  63 */ "attribute ::= SPACE ID EQUAL expr",
 /*  64 */ "attribute ::= SPACE ID EQUAL value",
 /*  65 */ "attribute ::= SPACE ID",
 /*  66 */ "attribute ::= SPACE expr",
 /*  67 */ "attribute ::= SPACE value",
 /*  68 */ "attribute ::= SPACE INTEGER EQUAL expr",
 /*  69 */ "statements ::= statement",
 /*  70 */ "statements ::= statements COMMA statement",
 /*  71 */ "statement ::= DOLLAR varvar EQUAL expr",
 /*  72 */ "expr ::= value",
 /*  73 */ "expr ::= ternary",
 /*  74 */ "expr ::= DOLLAR ID COLON ID",
 /*  75 */ "expr ::= expr MATH value",
 /*  76 */ "expr ::= expr UNIMATH value",
 /*  77 */ "expr ::= expr ANDSYM value",
 /*  78 */ "expr ::= array",
 /*  79 */ "expr ::= expr modifierlist",
 /*  80 */ "expr ::= expr ifcond expr",
 /*  81 */ "expr ::= expr ISIN array",
 /*  82 */ "expr ::= expr ISIN value",
 /*  83 */ "expr ::= expr lop expr",
 /*  84 */ "expr ::= expr ISDIVBY expr",
 /*  85 */ "expr ::= expr ISNOTDIVBY expr",
 /*  86 */ "expr ::= expr ISEVEN",
 /*  87 */ "expr ::= expr ISNOTEVEN",
 /*  88 */ "expr ::= expr ISEVENBY expr",
 /*  89 */ "expr ::= expr ISNOTEVENBY expr",
 /*  90 */ "expr ::= expr ISODD",
 /*  91 */ "expr ::= expr ISNOTODD",
 /*  92 */ "expr ::= expr ISODDBY expr",
 /*  93 */ "expr ::= expr ISNOTODDBY expr",
 /*  94 */ "expr ::= value INSTANCEOF ID",
 /*  95 */ "expr ::= value INSTANCEOF value",
 /*  96 */ "ternary ::= OPENP expr CLOSEP QMARK DOLLAR ID COLON expr",
 /*  97 */ "ternary ::= OPENP expr CLOSEP QMARK expr COLON expr",
 /*  98 */ "value ::= variable",
 /*  99 */ "value ::= UNIMATH value",
 /* 100 */ "value ::= NOT value",
 /* 101 */ "value ::= TYPECAST value",
 /* 102 */ "value ::= variable INCDEC",
 /* 103 */ "value ::= HEX",
 /* 104 */ "value ::= INTEGER",
 /* 105 */ "value ::= INTEGER DOT INTEGER",
 /* 106 */ "value ::= INTEGER DOT",
 /* 107 */ "value ::= DOT INTEGER",
 /* 108 */ "value ::= ID",
 /* 109 */ "value ::= function",
 /* 110 */ "value ::= OPENP expr CLOSEP",
 /* 111 */ "value ::= SINGLEQUOTESTRING",
 /* 112 */ "value ::= doublequoted_with_quotes",
 /* 113 */ "value ::= ID DOUBLECOLON static_class_access",
 /* 114 */ "value ::= varindexed DOUBLECOLON static_class_access",
 /* 115 */ "value ::= smartytag",
 /* 116 */ "variable ::= varindexed",
 /* 117 */ "variable ::= DOLLAR varvar AT ID",
 /* 118 */ "variable ::= object",
 /* 119 */ "variable ::= HATCH ID HATCH",
 /* 120 */ "variable ::= HATCH variable HATCH",
 /* 121 */ "varindexed ::= DOLLAR varvar arrayindex",
 /* 122 */ "arrayindex ::= arrayindex indexdef",
 /* 123 */ "arrayindex ::=",
 /* 124 */ "indexdef ::= DOT DOLLAR varvar",
 /* 125 */ "indexdef ::= DOT DOLLAR varvar AT ID",
 /* 126 */ "indexdef ::= DOT ID",
 /* 127 */ "indexdef ::= DOT INTEGER",
 /* 128 */ "indexdef ::= DOT LDEL expr RDEL",
 /* 129 */ "indexdef ::= OPENB ID CLOSEB",
 /* 130 */ "indexdef ::= OPENB ID DOT ID CLOSEB",
 /* 131 */ "indexdef ::= OPENB expr CLOSEB",
 /* 132 */ "indexdef ::= OPENB CLOSEB",
 /* 133 */ "varvar ::= varvarele",
 /* 134 */ "varvar ::= varvar varvarele",
 /* 135 */ "varvarele ::= ID",
 /* 136 */ "varvarele ::= LDEL expr RDEL",
 /* 137 */ "object ::= varindexed objectchain",
 /* 138 */ "objectchain ::= objectelement",
 /* 139 */ "objectchain ::= objectchain objectelement",
 /* 140 */ "objectelement ::= PTR ID arrayindex",
 /* 141 */ "objectelement ::= PTR DOLLAR varvar arrayindex",
 /* 142 */ "objectelement ::= PTR LDEL expr RDEL arrayindex",
 /* 143 */ "objectelement ::= PTR ID LDEL expr RDEL arrayindex",
 /* 144 */ "objectelement ::= PTR method",
 /* 145 */ "function ::= ID OPENP params CLOSEP",
 /* 146 */ "method ::= ID OPENP params CLOSEP",
 /* 147 */ "method ::= DOLLAR ID OPENP params CLOSEP",
 /* 148 */ "params ::= params COMMA expr",
 /* 149 */ "params ::= expr",
 /* 150 */ "params ::=",
 /* 151 */ "modifierlist ::= modifierlist modifier modparameters",
 /* 152 */ "modifierlist ::= modifier modparameters",
 /* 153 */ "modifier ::= VERT AT ID",
 /* 154 */ "modifier ::= VERT ID",
 /* 155 */ "modparameters ::= modparameters modparameter",
 /* 156 */ "modparameters ::=",
 /* 157 */ "modparameter ::= COLON value",
 /* 158 */ "modparameter ::= COLON array",
 /* 159 */ "static_class_access ::= method",
 /* 160 */ "static_class_access ::= method objectchain",
 /* 161 */ "static_class_access ::= ID",
 /* 162 */ "static_class_access ::= DOLLAR ID arrayindex",
 /* 163 */ "static_class_access ::= DOLLAR ID arrayindex objectchain",
 /* 164 */ "ifcond ::= EQUALS",
 /* 165 */ "ifcond ::= NOTEQUALS",
 /* 166 */ "ifcond ::= GREATERTHAN",
 /* 167 */ "ifcond ::= LESSTHAN",
 /* 168 */ "ifcond ::= GREATEREQUAL",
 /* 169 */ "ifcond ::= LESSEQUAL",
 /* 170 */ "ifcond ::= IDENTITY",
 /* 171 */ "ifcond ::= NONEIDENTITY",
 /* 172 */ "ifcond ::= MOD",
 /* 173 */ "lop ::= LAND",
 /* 174 */ "lop ::= LOR",
 /* 175 */ "lop ::= LXOR",
 /* 176 */ "array ::= OPENB arrayelements CLOSEB",
 /* 177 */ "arrayelements ::= arrayelement",
 /* 178 */ "arrayelements ::= arrayelements COMMA arrayelement",
 /* 179 */ "arrayelements ::=",
 /* 180 */ "arrayelement ::= value APTR expr",
 /* 181 */ "arrayelement ::= ID APTR expr",
 /* 182 */ "arrayelement ::= expr",
 /* 183 */ "doublequoted_with_quotes ::= QUOTE QUOTE",
 /* 184 */ "doublequoted_with_quotes ::= QUOTE doublequoted QUOTE",
 /* 185 */ "doublequoted ::= doublequoted doublequotedcontent",
 /* 186 */ "doublequoted ::= doublequotedcontent",
 /* 187 */ "doublequotedcontent ::= BACKTICK variable BACKTICK",
 /* 188 */ "doublequotedcontent ::= BACKTICK expr BACKTICK",
 /* 189 */ "doublequotedcontent ::= DOLLARID",
 /* 190 */ "doublequotedcontent ::= LDEL variable RDEL",
 /* 191 */ "doublequotedcontent ::= LDEL expr RDEL",
 /* 192 */ "doublequotedcontent ::= smartytag",
 /* 193 */ "doublequotedcontent ::= OTHER",
 /* 194 */ "optspace ::= SPACE",
 /* 195 */ "optspace ::=",
    );

    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
		        $expected = array_merge($expected, self::$yyExpectedTokens[$nextstate]);
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
	$this->yyidx = $yyidx;
	$this->yystack = $stack;
        return array_unique($expected);
    }

    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

   function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
#line 84 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->compiler->trigger_template_error("Stack overflow in template parser");
#line 1691 "smarty_internal_templateparser.php"
            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    static public $yyRuleInfo = array(
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 2 ),
  array( 'lhs' => 80, 'rhs' => 0 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 2 ),
  array( 'lhs' => 83, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 2 ),
  array( 'lhs' => 84, 'rhs' => 0 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 7 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 7 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 13 ),
  array( 'lhs' => 96, 'rhs' => 2 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 7 ),
  array( 'lhs' => 82, 'rhs' => 9 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 8 ),
  array( 'lhs' => 82, 'rhs' => 11 ),
  array( 'lhs' => 82, 'rhs' => 8 ),
  array( 'lhs' => 82, 'rhs' => 11 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 0 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 93, 'rhs' => 1 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 4 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 4 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 98, 'rhs' => 8 ),
  array( 'lhs' => 98, 'rhs' => 7 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 4 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 0 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 5 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 4 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 5 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 2 ),
  array( 'lhs' => 108, 'rhs' => 1 ),
  array( 'lhs' => 108, 'rhs' => 3 ),
  array( 'lhs' => 105, 'rhs' => 2 ),
  array( 'lhs' => 109, 'rhs' => 1 ),
  array( 'lhs' => 109, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 3 ),
  array( 'lhs' => 110, 'rhs' => 4 ),
  array( 'lhs' => 110, 'rhs' => 5 ),
  array( 'lhs' => 110, 'rhs' => 6 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 102, 'rhs' => 4 ),
  array( 'lhs' => 111, 'rhs' => 4 ),
  array( 'lhs' => 111, 'rhs' => 5 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 1 ),
  array( 'lhs' => 112, 'rhs' => 0 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 113, 'rhs' => 3 ),
  array( 'lhs' => 113, 'rhs' => 2 ),
  array( 'lhs' => 114, 'rhs' => 2 ),
  array( 'lhs' => 114, 'rhs' => 0 ),
  array( 'lhs' => 115, 'rhs' => 2 ),
  array( 'lhs' => 115, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 4 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 99, 'rhs' => 3 ),
  array( 'lhs' => 116, 'rhs' => 1 ),
  array( 'lhs' => 116, 'rhs' => 3 ),
  array( 'lhs' => 116, 'rhs' => 0 ),
  array( 'lhs' => 117, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 2 ),
  array( 'lhs' => 103, 'rhs' => 3 ),
  array( 'lhs' => 118, 'rhs' => 2 ),
  array( 'lhs' => 118, 'rhs' => 1 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 0 ),
    );

    static public $yyReduceMap = array(
        0 => 0,
        1 => 1,
        2 => 1,
        4 => 4,
        5 => 5,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        10 => 10,
        11 => 11,
        12 => 12,
        13 => 13,
        14 => 14,
        15 => 15,
        18 => 15,
        16 => 16,
        17 => 17,
        99 => 17,
        101 => 17,
        102 => 17,
        160 => 17,
        19 => 19,
        20 => 19,
        72 => 19,
        73 => 19,
        98 => 19,
        103 => 19,
        104 => 19,
        109 => 19,
        111 => 19,
        112 => 19,
        118 => 19,
        159 => 19,
        177 => 19,
        21 => 21,
        22 => 21,
        23 => 23,
        24 => 24,
        25 => 25,
        26 => 26,
        27 => 27,
        28 => 27,
        30 => 27,
        29 => 29,
        31 => 31,
        32 => 31,
        33 => 33,
        34 => 34,
        35 => 35,
        36 => 36,
        37 => 37,
        38 => 38,
        39 => 39,
        40 => 40,
        42 => 40,
        41 => 41,
        43 => 41,
        44 => 44,
        45 => 45,
        46 => 46,
        66 => 46,
        67 => 46,
        161 => 46,
        182 => 46,
        47 => 47,
        48 => 48,
        49 => 49,
        50 => 50,
        51 => 51,
        52 => 52,
        53 => 53,
        54 => 54,
        55 => 55,
        56 => 56,
        57 => 57,
        58 => 58,
        59 => 59,
        60 => 60,
        69 => 60,
        149 => 60,
        153 => 60,
        61 => 61,
        150 => 61,
        62 => 62,
        63 => 63,
        64 => 63,
        65 => 65,
        68 => 68,
        70 => 70,
        71 => 71,
        74 => 74,
        75 => 75,
        76 => 75,
        77 => 75,
        78 => 78,
        133 => 78,
        194 => 78,
        79 => 79,
        80 => 80,
        83 => 80,
        94 => 80,
        81 => 81,
        82 => 82,
        84 => 84,
        85 => 85,
        86 => 86,
        91 => 86,
        87 => 87,
        90 => 87,
        88 => 88,
        93 => 88,
        89 => 89,
        92 => 89,
        95 => 95,
        96 => 96,
        97 => 97,
        100 => 100,
        105 => 105,
        106 => 106,
        107 => 107,
        108 => 108,
        110 => 110,
        113 => 113,
        114 => 114,
        115 => 115,
        116 => 116,
        117 => 117,
        119 => 119,
        120 => 120,
        121 => 121,
        122 => 122,
        123 => 123,
        124 => 124,
        125 => 125,
        126 => 126,
        127 => 127,
        128 => 128,
        131 => 128,
        129 => 129,
        130 => 130,
        132 => 132,
        134 => 134,
        135 => 135,
        136 => 136,
        137 => 137,
        138 => 138,
        139 => 139,
        140 => 140,
        141 => 141,
        142 => 142,
        143 => 143,
        144 => 144,
        145 => 145,
        146 => 146,
        147 => 147,
        148 => 148,
        151 => 151,
        152 => 152,
        154 => 154,
        155 => 155,
        156 => 156,
        157 => 157,
        158 => 157,
        162 => 162,
        163 => 163,
        164 => 164,
        165 => 165,
        166 => 166,
        167 => 167,
        168 => 168,
        169 => 169,
        170 => 170,
        171 => 171,
        172 => 172,
        173 => 173,
        174 => 174,
        175 => 175,
        176 => 176,
        178 => 178,
        179 => 179,
        180 => 180,
        181 => 181,
        183 => 183,
        184 => 184,
        185 => 185,
        186 => 186,
        187 => 187,
        188 => 187,
        190 => 187,
        189 => 189,
        191 => 191,
        192 => 192,
        193 => 193,
        195 => 195,
    );
#line 95 "smarty_internal_templateparser.y"
    function yy_r0(){ $this->_retvalue = $this->root_buffer->to_smarty_php();     }
#line 2109 "smarty_internal_templateparser.php"
#line 101 "smarty_internal_templateparser.y"
    function yy_r1(){ $this->current_buffer->append_subtree($this->yystack[$this->yyidx + 0]->minor);     }
#line 2112 "smarty_internal_templateparser.php"
#line 113 "smarty_internal_templateparser.y"
    function yy_r4(){
                                          if ($this->compiler->has_code) {
                                            $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
                                            $this->_retvalue = new _smarty_tag($this, $this->compiler->processNocacheCode($tmp.$this->yystack[$this->yyidx + 0]->minor,true));
                                         } else { 
                                           $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
                                         }  
                                         $this->compiler->has_variable_string = false;
                                         $this->block_nesting_level = count($this->compiler->_tag_stack);
                                            }
#line 2124 "smarty_internal_templateparser.php"
#line 125 "smarty_internal_templateparser.y"
    function yy_r5(){ $this->_retvalue = new _smarty_tag($this, '');    }
#line 2127 "smarty_internal_templateparser.php"
#line 128 "smarty_internal_templateparser.y"
    function yy_r6(){ $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2130 "smarty_internal_templateparser.php"
#line 131 "smarty_internal_templateparser.y"
    function yy_r7(){
                                      if ($this->php_handling == Smarty::PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));
                                      } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
                                      }elseif ($this->php_handling == Smarty::PHP_ALLOW) {
                                       $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<?php', true));
                                      }elseif ($this->php_handling == Smarty::PHP_REMOVE) {
                                       $this->_retvalue = new _smarty_text($this, '');
                                      }
                                         }
#line 2143 "smarty_internal_templateparser.php"
#line 143 "smarty_internal_templateparser.y"
    function yy_r8(){if ($this->is_xml) {
                                       $this->compiler->tag_nocache = true; 
                                       $this->is_xml = true; 
                                       $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '?>';?>", $this->compiler, true));
                                      }elseif ($this->php_handling == Smarty::PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, '?<?php ?>>');
                                      } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars('?>', ENT_QUOTES));
                                      }elseif ($this->php_handling == Smarty::PHP_ALLOW) {
                                       $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('?>', true));
                                      }elseif ($this->php_handling == Smarty::PHP_REMOVE) {
                                       $this->_retvalue = new _smarty_text($this, '');
                                      }
                                         }
#line 2159 "smarty_internal_templateparser.php"
#line 159 "smarty_internal_templateparser.y"
    function yy_r9(){
                                      if ($this->php_handling == Smarty::PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
                                      } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
                                      }elseif ($this->php_handling == Smarty::PHP_ALLOW) {
                                        if ($this->asp_tags) {
                                          $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<%', true));
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
                                        }
                                      }elseif ($this->php_handling == Smarty::PHP_REMOVE) {
                                        if ($this->asp_tags) {
                                         $this->_retvalue = new _smarty_text($this, '');
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
                                        }
                                      }
                                        }
#line 2180 "smarty_internal_templateparser.php"
#line 180 "smarty_internal_templateparser.y"
    function yy_r10(){
                                      if ($this->php_handling == Smarty::PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
                                      } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars('%>', ENT_QUOTES));
                                      }elseif ($this->php_handling == Smarty::PHP_ALLOW) {
                                        if ($this->asp_tags) {
                                          $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('%>', true));
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
                                        }
                                      }elseif ($this->php_handling == Smarty::PHP_REMOVE) {
                                        if ($this->asp_tags) {
                                         $this->_retvalue = new _smarty_text($this, '');
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
                                        }
                                      }
                                        }
#line 2201 "smarty_internal_templateparser.php"
#line 200 "smarty_internal_templateparser.y"
    function yy_r11(){if ($this->lex->strip) {
                                       $this->_retvalue = new _smarty_text($this, preg_replace('![\$this->yystack[$this->yyidx + 0]->minor ]*[\r\n]+[\$this->yystack[$this->yyidx + 0]->minor ]*!', '', self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor)));	
                                     } else {
                                       $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));	
                                     }
                                        }
#line 2209 "smarty_internal_templateparser.php"
#line 208 "smarty_internal_templateparser.y"
    function yy_r12(){ $this->compiler->tag_nocache = true; $this->is_xml = true; $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '<?xml';?>", $this->compiler, true));    }
#line 2212 "smarty_internal_templateparser.php"
#line 211 "smarty_internal_templateparser.y"
    function yy_r13(){if ($this->lex->strip) {
                                       $this->_retvalue = new _smarty_text($this, preg_replace('![\t ]*[\r\n]+[\t ]*!', '', $this->yystack[$this->yyidx + 0]->minor));	
                                     } else {
                                       $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);	
                                     }
                                        }
#line 2220 "smarty_internal_templateparser.php"
#line 217 "smarty_internal_templateparser.y"
    function yy_r14(){
                                     $this->_retvalue = new _smarty_linebreak($this, $this->yystack[$this->yyidx + 0]->minor);
                                       }
#line 2225 "smarty_internal_templateparser.php"
#line 222 "smarty_internal_templateparser.y"
    function yy_r15(){ $this->_retvalue = '';     }
#line 2228 "smarty_internal_templateparser.php"
#line 223 "smarty_internal_templateparser.y"
    function yy_r16(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2231 "smarty_internal_templateparser.php"
#line 225 "smarty_internal_templateparser.y"
    function yy_r17(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2234 "smarty_internal_templateparser.php"
#line 228 "smarty_internal_templateparser.y"
    function yy_r19(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2237 "smarty_internal_templateparser.php"
#line 230 "smarty_internal_templateparser.y"
    function yy_r21(){ $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2240 "smarty_internal_templateparser.php"
#line 232 "smarty_internal_templateparser.y"
    function yy_r23(){ $this->_retvalue = self::escape_end_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2243 "smarty_internal_templateparser.php"
#line 233 "smarty_internal_templateparser.y"
    function yy_r24(){ $this->_retvalue = '<<?php ?>%';     }
#line 2246 "smarty_internal_templateparser.php"
#line 234 "smarty_internal_templateparser.y"
    function yy_r25(){ $this->_retvalue = '%<?php ?>>';     }
#line 2249 "smarty_internal_templateparser.php"
#line 242 "smarty_internal_templateparser.y"
    function yy_r26(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',array(),array('value'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2252 "smarty_internal_templateparser.php"
#line 243 "smarty_internal_templateparser.y"
    function yy_r27(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2255 "smarty_internal_templateparser.php"
#line 245 "smarty_internal_templateparser.y"
    function yy_r29(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -3]->minor,'modifierlist'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2258 "smarty_internal_templateparser.php"
#line 253 "smarty_internal_templateparser.y"
    function yy_r31(){ $this->_retvalue = $this->compiler->compileTag('assign',array(array('value'=>$this->yystack[$this->yyidx + -1]->minor),array('var'=>"'".$this->yystack[$this->yyidx + -3]->minor."'")));    }
#line 2261 "smarty_internal_templateparser.php"
#line 255 "smarty_internal_templateparser.y"
    function yy_r33(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + -2]->minor),array('var'=>"'".$this->yystack[$this->yyidx + -4]->minor."'")),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2264 "smarty_internal_templateparser.php"
#line 256 "smarty_internal_templateparser.y"
    function yy_r34(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + -2]->minor),array('var'=>$this->yystack[$this->yyidx + -4]->minor['var'])),$this->yystack[$this->yyidx + -1]->minor),array('smarty_internal_index'=>$this->yystack[$this->yyidx + -4]->minor['smarty_internal_index']));    }
#line 2267 "smarty_internal_templateparser.php"
#line 258 "smarty_internal_templateparser.y"
    function yy_r35(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,$this->yystack[$this->yyidx + -1]->minor);    }
#line 2270 "smarty_internal_templateparser.php"
#line 259 "smarty_internal_templateparser.y"
    function yy_r36(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,array());    }
#line 2273 "smarty_internal_templateparser.php"
#line 261 "smarty_internal_templateparser.y"
    function yy_r37(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor,array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2276 "smarty_internal_templateparser.php"
#line 263 "smarty_internal_templateparser.y"
    function yy_r38(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor,$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
                                                                                    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
                                                                                     }
#line 2281 "smarty_internal_templateparser.php"
#line 267 "smarty_internal_templateparser.y"
    function yy_r39(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -5]->minor,$this->yystack[$this->yyidx + -1]->minor,array('object_methode'=>$this->yystack[$this->yyidx + -3]->minor)).'<?php echo ';
                                                                                               $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
                                                                                                }
#line 2286 "smarty_internal_templateparser.php"
#line 271 "smarty_internal_templateparser.y"
    function yy_r40(){ $tag = trim(substr($this->yystack[$this->yyidx + -3]->minor,$this->lex->ldel_length)); $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,array(),array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2289 "smarty_internal_templateparser.php"
#line 272 "smarty_internal_templateparser.y"
    function yy_r41(){ $tag = trim(substr($this->yystack[$this->yyidx + -4]->minor,$this->lex->ldel_length)); $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,$this->yystack[$this->yyidx + -1]->minor,array('if condition'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2292 "smarty_internal_templateparser.php"
#line 276 "smarty_internal_templateparser.y"
    function yy_r44(){
                                                             $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -10]->minor),array('ifexp'=>$this->yystack[$this->yyidx + -7]->minor),array('var'=>$this->yystack[$this->yyidx + -3]->minor),array('step'=>$this->yystack[$this->yyidx + -2]->minor))),1);    }
#line 2296 "smarty_internal_templateparser.php"
#line 279 "smarty_internal_templateparser.y"
    function yy_r45(){ $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2299 "smarty_internal_templateparser.php"
#line 280 "smarty_internal_templateparser.y"
    function yy_r46(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2302 "smarty_internal_templateparser.php"
#line 281 "smarty_internal_templateparser.y"
    function yy_r47(){ $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -4]->minor),array('to'=>$this->yystack[$this->yyidx + -2]->minor))),0);    }
#line 2305 "smarty_internal_templateparser.php"
#line 282 "smarty_internal_templateparser.y"
    function yy_r48(){ $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -6]->minor),array('to'=>$this->yystack[$this->yyidx + -4]->minor),array('step'=>$this->yystack[$this->yyidx + -2]->minor))),0);    }
#line 2308 "smarty_internal_templateparser.php"
#line 284 "smarty_internal_templateparser.y"
    function yy_r49(){ $this->_retvalue = $this->compiler->compileTag('foreach',$this->yystack[$this->yyidx + -1]->minor);    }
#line 2311 "smarty_internal_templateparser.php"
#line 286 "smarty_internal_templateparser.y"
    function yy_r50(){
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -5]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor))));    }
#line 2315 "smarty_internal_templateparser.php"
#line 288 "smarty_internal_templateparser.y"
    function yy_r51(){
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -8]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor),array('key'=>$this->yystack[$this->yyidx + -5]->minor))));    }
#line 2319 "smarty_internal_templateparser.php"
#line 290 "smarty_internal_templateparser.y"
    function yy_r52(){ 
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -5]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor))));    }
#line 2323 "smarty_internal_templateparser.php"
#line 292 "smarty_internal_templateparser.y"
    function yy_r53(){ 
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -8]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor),array('key'=>$this->yystack[$this->yyidx + -5]->minor))));    }
#line 2327 "smarty_internal_templateparser.php"
#line 296 "smarty_internal_templateparser.y"
    function yy_r54(){ $this->_retvalue = SMARTY_INTERNAL_COMPILE_BLOCK::compileChildBlock($this->compiler);    }
#line 2330 "smarty_internal_templateparser.php"
#line 300 "smarty_internal_templateparser.y"
    function yy_r55(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor.'close',array());    }
#line 2333 "smarty_internal_templateparser.php"
#line 302 "smarty_internal_templateparser.y"
    function yy_r56(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',array(),array('modifier_list'=>$this->yystack[$this->yyidx + -1]->minor));
                                                                                          }
#line 2337 "smarty_internal_templateparser.php"
#line 305 "smarty_internal_templateparser.y"
    function yy_r57(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',array(),array('object_methode'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2340 "smarty_internal_templateparser.php"
#line 306 "smarty_internal_templateparser.y"
    function yy_r58(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor.'close',array(),array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor, 'modifier_list'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2343 "smarty_internal_templateparser.php"
#line 312 "smarty_internal_templateparser.y"
    function yy_r59(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor; $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2346 "smarty_internal_templateparser.php"
#line 314 "smarty_internal_templateparser.y"
    function yy_r60(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2349 "smarty_internal_templateparser.php"
#line 316 "smarty_internal_templateparser.y"
    function yy_r61(){ $this->_retvalue = array();    }
#line 2352 "smarty_internal_templateparser.php"
#line 319 "smarty_internal_templateparser.y"
    function yy_r62(){ if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'true');
                                                 } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'false');
                                                 } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'null');
                                                 } else
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>"'".$this->yystack[$this->yyidx + 0]->minor."'");    }
#line 2362 "smarty_internal_templateparser.php"
#line 327 "smarty_internal_templateparser.y"
    function yy_r63(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2365 "smarty_internal_templateparser.php"
#line 329 "smarty_internal_templateparser.y"
    function yy_r65(){ $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";    }
#line 2368 "smarty_internal_templateparser.php"
#line 332 "smarty_internal_templateparser.y"
    function yy_r68(){$this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2371 "smarty_internal_templateparser.php"
#line 339 "smarty_internal_templateparser.y"
    function yy_r70(){ $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;    }
#line 2374 "smarty_internal_templateparser.php"
#line 341 "smarty_internal_templateparser.y"
    function yy_r71(){ $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2377 "smarty_internal_templateparser.php"
#line 352 "smarty_internal_templateparser.y"
    function yy_r74(){$this->_retvalue = '$_smarty_tpl->getStreamVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'://'. $this->yystack[$this->yyidx + 0]->minor . '\')';    }
#line 2380 "smarty_internal_templateparser.php"
#line 354 "smarty_internal_templateparser.y"
    function yy_r75(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . trim($this->yystack[$this->yyidx + -1]->minor) . $this->yystack[$this->yyidx + 0]->minor;     }
#line 2383 "smarty_internal_templateparser.php"
#line 360 "smarty_internal_templateparser.y"
    function yy_r78(){$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2386 "smarty_internal_templateparser.php"
#line 363 "smarty_internal_templateparser.y"
    function yy_r79(){  $this->_retvalue = $this->compiler->compileTag('private_modifier',array(),array('value'=>$this->yystack[$this->yyidx + -1]->minor,'modifierlist'=>$this->yystack[$this->yyidx + 0]->minor));     }
#line 2389 "smarty_internal_templateparser.php"
#line 367 "smarty_internal_templateparser.y"
    function yy_r80(){$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2392 "smarty_internal_templateparser.php"
#line 368 "smarty_internal_templateparser.y"
    function yy_r81(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2395 "smarty_internal_templateparser.php"
#line 369 "smarty_internal_templateparser.y"
    function yy_r82(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2398 "smarty_internal_templateparser.php"
#line 371 "smarty_internal_templateparser.y"
    function yy_r84(){$this->_retvalue = '!('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2401 "smarty_internal_templateparser.php"
#line 372 "smarty_internal_templateparser.y"
    function yy_r85(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2404 "smarty_internal_templateparser.php"
#line 373 "smarty_internal_templateparser.y"
    function yy_r86(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2407 "smarty_internal_templateparser.php"
#line 374 "smarty_internal_templateparser.y"
    function yy_r87(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2410 "smarty_internal_templateparser.php"
#line 375 "smarty_internal_templateparser.y"
    function yy_r88(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2413 "smarty_internal_templateparser.php"
#line 376 "smarty_internal_templateparser.y"
    function yy_r89(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2416 "smarty_internal_templateparser.php"
#line 382 "smarty_internal_templateparser.y"
    function yy_r95(){$this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->yystack[$this->yyidx + 0]->minor.';?>'; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'$_tmp'.$this->prefix_number;    }
#line 2419 "smarty_internal_templateparser.php"
#line 388 "smarty_internal_templateparser.y"
    function yy_r96(){ $this->_retvalue = $this->yystack[$this->yyidx + -6]->minor.' ? $_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'\')->value : '.$this->yystack[$this->yyidx + 0]->minor;  $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable('$this->yystack[$this->yyidx + -2]->minor', null, true, false)->nocache;    }
#line 2422 "smarty_internal_templateparser.php"
#line 389 "smarty_internal_templateparser.y"
    function yy_r97(){ $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2425 "smarty_internal_templateparser.php"
#line 396 "smarty_internal_templateparser.y"
    function yy_r100(){ $this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2428 "smarty_internal_templateparser.php"
#line 402 "smarty_internal_templateparser.y"
    function yy_r105(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2431 "smarty_internal_templateparser.php"
#line 403 "smarty_internal_templateparser.y"
    function yy_r106(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.';     }
#line 2434 "smarty_internal_templateparser.php"
#line 404 "smarty_internal_templateparser.y"
    function yy_r107(){ $this->_retvalue = '.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2437 "smarty_internal_templateparser.php"
#line 406 "smarty_internal_templateparser.y"
    function yy_r108(){ if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'true';
                               } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'false';
                               } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'null';
                               } else
                               $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";     }
#line 2447 "smarty_internal_templateparser.php"
#line 417 "smarty_internal_templateparser.y"
    function yy_r110(){ $this->_retvalue = "(". $this->yystack[$this->yyidx + -1]->minor .")";     }
#line 2450 "smarty_internal_templateparser.php"
#line 423 "smarty_internal_templateparser.y"
    function yy_r113(){if (!$this->security || isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor]) || $this->smarty->security_policy->isTrustedStaticClass($this->yystack[$this->yyidx + -2]->minor, $this->compiler)) {
                      																				   if (isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor])) {
                                                                  $this->_retvalue = $this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor].'::'.$this->yystack[$this->yyidx + 0]->minor;
                      																				   } else {
                                                                  $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor;
                                                                 } 
                                                                } else {
                                                                 $this->compiler->trigger_template_error ("static class '".$this->yystack[$this->yyidx + -2]->minor."' is undefined or not allowed by security setting");
                                                                }
                                                                   }
#line 2462 "smarty_internal_templateparser.php"
#line 433 "smarty_internal_templateparser.y"
    function yy_r114(){ if ($this->yystack[$this->yyidx + -2]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index']).'::'.$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index'].'::'.$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2466 "smarty_internal_templateparser.php"
#line 436 "smarty_internal_templateparser.y"
    function yy_r115(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + 0]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>'; $this->_retvalue = '$_tmp'.$this->prefix_number;     }
#line 2469 "smarty_internal_templateparser.php"
#line 445 "smarty_internal_templateparser.y"
    function yy_r116(){if ($this->yystack[$this->yyidx + 0]->minor['var'] == '\'smarty\'') {
																				$smarty_var = $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']);
																				$this->_retvalue = $smarty_var;
                                      } else {
                                      	// used for array reset,next,prev,end,current 
                                      	$this->last_variable = $this->yystack[$this->yyidx + 0]->minor['var'];
                                      	$this->last_index = $this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
                                      	if (isset($this->compiler->local_var[$this->yystack[$this->yyidx + 0]->minor['var']])) {
                                          $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + 0]->minor['var'] .']->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
                                      	} else {
                                          $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor['var'] .')->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
                                      	}
                                      	$this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor['var'],"'"), null, true, false)->nocache;
                                     }
                                        }
#line 2486 "smarty_internal_templateparser.php"
#line 461 "smarty_internal_templateparser.y"
    function yy_r117(){if (isset($this->compiler->local_var[$this->yystack[$this->yyidx + -2]->minor])) {
                                                  $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + -2]->minor .']->'.$this->yystack[$this->yyidx + 0]->minor;
                                                 } else {
                                                  $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor;
                                                 }
                                                  $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2494 "smarty_internal_templateparser.php"
#line 470 "smarty_internal_templateparser.y"
    function yy_r119(){$this->_retvalue = '$_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -1]->minor .'\')';    }
#line 2497 "smarty_internal_templateparser.php"
#line 471 "smarty_internal_templateparser.y"
    function yy_r120(){$this->_retvalue = '$_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -1]->minor .')';    }
#line 2500 "smarty_internal_templateparser.php"
#line 474 "smarty_internal_templateparser.y"
    function yy_r121(){$this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2503 "smarty_internal_templateparser.php"
#line 480 "smarty_internal_templateparser.y"
    function yy_r122(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2506 "smarty_internal_templateparser.php"
#line 482 "smarty_internal_templateparser.y"
    function yy_r123(){return;    }
#line 2509 "smarty_internal_templateparser.php"
#line 486 "smarty_internal_templateparser.y"
    function yy_r124(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor .')->value]'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable('$this->yystack[$this->yyidx + 0]->minor', null, true, false)->nocache;    }
#line 2512 "smarty_internal_templateparser.php"
#line 487 "smarty_internal_templateparser.y"
    function yy_r125(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor.']'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2515 "smarty_internal_templateparser.php"
#line 488 "smarty_internal_templateparser.y"
    function yy_r126(){ $this->_retvalue = "['". $this->yystack[$this->yyidx + 0]->minor ."']";    }
#line 2518 "smarty_internal_templateparser.php"
#line 489 "smarty_internal_templateparser.y"
    function yy_r127(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + 0]->minor ."]";    }
#line 2521 "smarty_internal_templateparser.php"
#line 490 "smarty_internal_templateparser.y"
    function yy_r128(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + -1]->minor ."]";    }
#line 2524 "smarty_internal_templateparser.php"
#line 492 "smarty_internal_templateparser.y"
    function yy_r129(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable',array(),'[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';    }
#line 2527 "smarty_internal_templateparser.php"
#line 493 "smarty_internal_templateparser.y"
    function yy_r130(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable',array(),'[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';    }
#line 2530 "smarty_internal_templateparser.php"
#line 497 "smarty_internal_templateparser.y"
    function yy_r132(){$this->_retvalue = '[]';    }
#line 2533 "smarty_internal_templateparser.php"
#line 505 "smarty_internal_templateparser.y"
    function yy_r134(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2536 "smarty_internal_templateparser.php"
#line 507 "smarty_internal_templateparser.y"
    function yy_r135(){$this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';    }
#line 2539 "smarty_internal_templateparser.php"
#line 509 "smarty_internal_templateparser.y"
    function yy_r136(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2542 "smarty_internal_templateparser.php"
#line 514 "smarty_internal_templateparser.y"
    function yy_r137(){ if ($this->yystack[$this->yyidx + -1]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']).$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index'].$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2546 "smarty_internal_templateparser.php"
#line 517 "smarty_internal_templateparser.y"
    function yy_r138(){$this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2549 "smarty_internal_templateparser.php"
#line 519 "smarty_internal_templateparser.y"
    function yy_r139(){$this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2552 "smarty_internal_templateparser.php"
#line 521 "smarty_internal_templateparser.y"
    function yy_r140(){if ($this->security && substr($this->yystack[$this->yyidx + -1]->minor,0,1) == '_') {
                                                      $this->compiler->trigger_template_error (self::Err1);
																									   }
                                                     $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
                                                         }
#line 2559 "smarty_internal_templateparser.php"
#line 526 "smarty_internal_templateparser.y"
    function yy_r141(){if ($this->security) {
                                                                 $this->compiler->trigger_template_error (self::Err2);
																															 }
                                                               $this->_retvalue = '->{$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor .')->value'.$this->yystack[$this->yyidx + 0]->minor.'}'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor,"'"), null, true, false)->nocache;
                                                                   }
#line 2566 "smarty_internal_templateparser.php"
#line 531 "smarty_internal_templateparser.y"
    function yy_r142(){if ($this->security) {
                                                                 $this->compiler->trigger_template_error (self::Err2);
																															   }
                     																						 $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
                     																						    }
#line 2573 "smarty_internal_templateparser.php"
#line 536 "smarty_internal_templateparser.y"
    function yy_r143(){if ($this->security) {
                                                                         $this->compiler->trigger_template_error (self::Err2);
																															         }
                                                                       $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
                                                                          }
#line 2580 "smarty_internal_templateparser.php"
#line 542 "smarty_internal_templateparser.y"
    function yy_r144(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2583 "smarty_internal_templateparser.php"
#line 548 "smarty_internal_templateparser.y"
    function yy_r145(){if (!$this->security || $this->smarty->security_policy->isTrustedPhpFunction($this->yystack[$this->yyidx + -3]->minor, $this->compiler)) {
																					            if (strcasecmp($this->yystack[$this->yyidx + -3]->minor,'isset') === 0 || strcasecmp($this->yystack[$this->yyidx + -3]->minor,'empty') === 0 || strcasecmp($this->yystack[$this->yyidx + -3]->minor,'array') === 0 || is_callable($this->yystack[$this->yyidx + -3]->minor)) {
																					                $func_name = strtolower($this->yystack[$this->yyidx + -3]->minor);
																					                if ($func_name == 'isset') {
																					                  if (count($this->yystack[$this->yyidx + -1]->minor) == 0) {
																					                   $this->compiler->trigger_template_error ('Illegal number of paramer in "isset()"');
																					                  }
																					                  $isset_par=str_replace("')->value","',null,true,false)->value",implode(',',$this->yystack[$this->yyidx + -1]->minor));
																					                  $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $isset_par .")";
																						              } elseif (in_array($func_name,array('empty','reset','current','end','prev','next'))){
																					                  if (count($this->yystack[$this->yyidx + -1]->minor) != 1) {
																					                   $this->compiler->trigger_template_error ('Illegal number of paramer in "empty()"');
																					                  }
																					                  $this->_retvalue = $func_name.'('.$this->yystack[$this->yyidx + -1]->minor[0].')';
																					                } else {
																					                  $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". implode(',',$this->yystack[$this->yyidx + -1]->minor) .")";
																					                }
																					            } else {
                                                       $this->compiler->trigger_template_error ("unknown function \"" . $this->yystack[$this->yyidx + -3]->minor . "\"");
                                                      }
                                                     }
                                                        }
#line 2607 "smarty_internal_templateparser.php"
#line 574 "smarty_internal_templateparser.y"
    function yy_r146(){if ($this->security && substr($this->yystack[$this->yyidx + -3]->minor,0,1) == '_') {
                                                      $this->compiler->trigger_template_error (self::Err1);
																									 }
                                                   $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". implode(',',$this->yystack[$this->yyidx + -1]->minor) .")";
                                                      }
#line 2614 "smarty_internal_templateparser.php"
#line 579 "smarty_internal_templateparser.y"
    function yy_r147(){if ($this->security) {
                                                              $this->compiler->trigger_template_error (self::Err2);
																													 }
                                                           $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'=$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -3]->minor .'\')->value;?>'; $this->_retvalue = '$_tmp'.$this->prefix_number.'('. implode(',',$this->yystack[$this->yyidx + -1]->minor) .')';
                                                              }
#line 2621 "smarty_internal_templateparser.php"
#line 587 "smarty_internal_templateparser.y"
    function yy_r148(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array($this->yystack[$this->yyidx + 0]->minor));    }
#line 2624 "smarty_internal_templateparser.php"
#line 596 "smarty_internal_templateparser.y"
    function yy_r151(){$this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor)));    }
#line 2627 "smarty_internal_templateparser.php"
#line 597 "smarty_internal_templateparser.y"
    function yy_r152(){$this->_retvalue = array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor));    }
#line 2630 "smarty_internal_templateparser.php"
#line 600 "smarty_internal_templateparser.y"
    function yy_r154(){ $this->_retvalue =  array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2633 "smarty_internal_templateparser.php"
#line 605 "smarty_internal_templateparser.y"
    function yy_r155(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);    }
#line 2636 "smarty_internal_templateparser.php"
#line 607 "smarty_internal_templateparser.y"
    function yy_r156(){$this->_retvalue = array();    }
#line 2639 "smarty_internal_templateparser.php"
#line 609 "smarty_internal_templateparser.y"
    function yy_r157(){$this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2642 "smarty_internal_templateparser.php"
#line 619 "smarty_internal_templateparser.y"
    function yy_r162(){ $this->_retvalue = '$'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2645 "smarty_internal_templateparser.php"
#line 621 "smarty_internal_templateparser.y"
    function yy_r163(){ $this->_retvalue = '$'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2648 "smarty_internal_templateparser.php"
#line 630 "smarty_internal_templateparser.y"
    function yy_r164(){$this->_retvalue = '==';    }
#line 2651 "smarty_internal_templateparser.php"
#line 631 "smarty_internal_templateparser.y"
    function yy_r165(){$this->_retvalue = '!=';    }
#line 2654 "smarty_internal_templateparser.php"
#line 632 "smarty_internal_templateparser.y"
    function yy_r166(){$this->_retvalue = '>';    }
#line 2657 "smarty_internal_templateparser.php"
#line 633 "smarty_internal_templateparser.y"
    function yy_r167(){$this->_retvalue = '<';    }
#line 2660 "smarty_internal_templateparser.php"
#line 634 "smarty_internal_templateparser.y"
    function yy_r168(){$this->_retvalue = '>=';    }
#line 2663 "smarty_internal_templateparser.php"
#line 635 "smarty_internal_templateparser.y"
    function yy_r169(){$this->_retvalue = '<=';    }
#line 2666 "smarty_internal_templateparser.php"
#line 636 "smarty_internal_templateparser.y"
    function yy_r170(){$this->_retvalue = '===';    }
#line 2669 "smarty_internal_templateparser.php"
#line 637 "smarty_internal_templateparser.y"
    function yy_r171(){$this->_retvalue = '!==';    }
#line 2672 "smarty_internal_templateparser.php"
#line 638 "smarty_internal_templateparser.y"
    function yy_r172(){$this->_retvalue = '%';    }
#line 2675 "smarty_internal_templateparser.php"
#line 640 "smarty_internal_templateparser.y"
    function yy_r173(){$this->_retvalue = '&&';    }
#line 2678 "smarty_internal_templateparser.php"
#line 641 "smarty_internal_templateparser.y"
    function yy_r174(){$this->_retvalue = '||';    }
#line 2681 "smarty_internal_templateparser.php"
#line 642 "smarty_internal_templateparser.y"
    function yy_r175(){$this->_retvalue = ' XOR ';    }
#line 2684 "smarty_internal_templateparser.php"
#line 647 "smarty_internal_templateparser.y"
    function yy_r176(){ $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2687 "smarty_internal_templateparser.php"
#line 649 "smarty_internal_templateparser.y"
    function yy_r178(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2690 "smarty_internal_templateparser.php"
#line 650 "smarty_internal_templateparser.y"
    function yy_r179(){ return;     }
#line 2693 "smarty_internal_templateparser.php"
#line 651 "smarty_internal_templateparser.y"
    function yy_r180(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2696 "smarty_internal_templateparser.php"
#line 652 "smarty_internal_templateparser.y"
    function yy_r181(){ $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2699 "smarty_internal_templateparser.php"
#line 659 "smarty_internal_templateparser.y"
    function yy_r183(){ $this->_retvalue = "''";     }
#line 2702 "smarty_internal_templateparser.php"
#line 660 "smarty_internal_templateparser.y"
    function yy_r184(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->to_smarty_php();     }
#line 2705 "smarty_internal_templateparser.php"
#line 662 "smarty_internal_templateparser.y"
    function yy_r185(){ $this->yystack[$this->yyidx + -1]->minor->append_subtree($this->yystack[$this->yyidx + 0]->minor); $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2708 "smarty_internal_templateparser.php"
#line 663 "smarty_internal_templateparser.y"
    function yy_r186(){ $this->_retvalue = new _smarty_doublequoted($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2711 "smarty_internal_templateparser.php"
#line 665 "smarty_internal_templateparser.y"
    function yy_r187(){ $this->_retvalue = new _smarty_code($this, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2714 "smarty_internal_templateparser.php"
#line 667 "smarty_internal_templateparser.y"
    function yy_r189(){if (isset($this->compiler->local_var["'".substr($this->yystack[$this->yyidx + 0]->minor,1)."'"])) {
                                                       $this->_retvalue = new _smarty_code($this, '$_smarty_tpl->tpl_vars[\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\']->value');
                                                      } else {
                                                       $this->_retvalue = new _smarty_code($this, '$_smarty_tpl->getVariable(\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\')->value');
                                                      }
                                                      $this->compiler->tag_nocache = $this->compiler->tag_nocache | $this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor,"'"), null, true, false)->nocache;
      }
#line 2723 "smarty_internal_templateparser.php"
#line 675 "smarty_internal_templateparser.y"
    function yy_r191(){ $this->_retvalue = new _smarty_code($this, '('.$this->yystack[$this->yyidx + -1]->minor.')');     }
#line 2726 "smarty_internal_templateparser.php"
#line 676 "smarty_internal_templateparser.y"
    function yy_r192(){
   $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
      }
#line 2731 "smarty_internal_templateparser.php"
#line 679 "smarty_internal_templateparser.y"
    function yy_r193(){ $this->_retvalue = new _smarty_dq_content($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2734 "smarty_internal_templateparser.php"
#line 686 "smarty_internal_templateparser.y"
    function yy_r195(){$this->_retvalue = '';    }
#line 2737 "smarty_internal_templateparser.php"

    private $_retvalue;

    function yy_reduce($yyruleno)
    {
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 77 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
#line 2800 "smarty_internal_templateparser.php"
    }

    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
#line 69 "smarty_internal_templateparser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    //echo $this->retvalue."\n\n";
#line 2818 "smarty_internal_templateparser.php"
    }

    function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
?>