<?php
  /*
   * ==============================================================================
   * SVT Play by Sveriges Television for Xtreamer Media Player & Streamer
   * ==============================================================================
   *
   * This project allows to watch content brom SVT Play is the brand used for the
   * video on demand service offered by Sveriges Television.
   *
   * Scraper based on SVT Play plugin for XBMC, xbmc-svtplay, code.google.com/p/xbmc-svtplay/
   *
   * Licence: GNU General Public License v2
   * http://www.gnu.org/licenses/gpl.html
   *
   * Do not remove or change any header comments! Respect our work!
   *
   * If you are satisfied with my work you can support it with small donation
   *   https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=SB8WDDAWY5YZE&lc=SI&item_name=xJukebox&item_number=ak5349jgdr&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted   *
   *
   * Author: vpeter
   *  http://forum.xtreamer.net/user/34082-vpeter/
   *
   * ==============================================================================
   */

  header('Content-type: text/plain; charset=utf-8');
  require_once 'functions.php';
  require_once 'svtplay_scraper.php';

  $selfUrl = 'http://'.$_SERVER['SERVER_NAME'] .$_SERVER['PHP_SELF'];

  $mode = @$_GET['mode'];
  if (is_null($mode) || $mode == '')
    $mode = '';

  $url = @$_GET['url'];
  if (is_null($url) || $url == '')
    $url = '';

  $submenu = @$_GET['submenu'];
  if (is_null($submenu) || $submenu == '')
    $submenu = -1;

  if ($mode == 'favread') {
    $favoritesFile = 'favorites.dat';
    $data = @file_get_contents($favoritesFile);
    if (! $data) {
    	$arr = array();
    } else {
    	$arr = unserialize($data);
    	unset($data);
    }
    
    $pageArrData['title'] = 'Favoriter';
    $pageArrData['items'] = $arr;
  } else {
    $pageArrData = scrapeArrData($mode, $url);
    if (! $pageArrData)
      die();

    if ($mode == 'search')
      $pageArrData['title'] .= ': '. substr($url, 2);
    else if ($mode == 'getlive')
      $pageArrData['title'] = 'Livesndningar';
  }

  if ($submenu < 2)
    $submenu = 2;

  echo '<?xml version="1.0" encoding="UTF-8" ?>';
?>
<rss version="2.0" >
  <!-- ---------------------------------------------------------  -->
  <!-- RSS DEBUG RSS FUNCTION WILL WRITE ENTRY IN debug.txt FILE  -->
  <!-- syntax: txt = "string to write"; executeScript("log");     -->
  <log>
    write = 01;
    if (write != "0") {
      old = readStringFromFile("/tmp/usbmounts/sda1/debug.txt");
      new = old + "&#x0A;" + date("%d.%m.%Y %H:%M:%S") + ": " + txt;
      writeStringToFile("/tmp/usbmounts/sda1/debug.txt", new);
    }
  </log>
  <!-- ---------------------------------------------------------  -->

<onEnter>
  SwitchViewer(0);
  SwitchViewer(7);
<?php
  if ($mode == 'favread')
    echo "  modeFavoritesRead = 1;\n";
  else
    echo "  modeFavoritesRead = 0;\n";

  echo "  menuSel = $submenu;  /* first 2 are special */\n";

  //if ($mode == '')
    //echo "  writeStringToFile(\"/tmp/svtplay.branch\", \"0\"); \n";
?>
  menuSelPrev = menuSel;
  itemCount = getPageInfo("itemCount");
  videoquality = readStringFromFile("/tmp/usbmounts/sda1/scripts/svtplay/quality.dat");
  if (videoquality == null || videoquality &lt; 1 || videoquality &gt; 4) {
    videoquality = 1;
    writeStringToFile("/tmp/usbmounts/sda1/scripts/svtplay/quality.dat", videoquality);
  }

  subtitle = readStringFromFile("/tmp/usbmounts/sda1/scripts/svtplay/subtitle.dat");
  if (subtitle == null || subtitle &lt; 0 || subtitle &gt; 1) {
    subtitle = 0;
    writeStringToFile("/tmp/usbmounts/sda1/scripts/svtplay/subtitle.dat", subtitle);
  }
</onEnter>

<script>
  postMessage("D");
</script>

<mediaDisplay name=photoView
showHeader="no"
drawItemText="no"
sideColorBottom="-1:-1:-1"
sideColorTop="-1:-1:-1"
rowCount="2"
columnCount="5"
itemOffsetXPC="17"
itemOffsetYPC="22"
itemWidthPC="12"
itemHeightPC="17"
itemImageWidthPC="12"
itemImageHeightPC="12"
itemBorderColor=170:200:255
itemBackgroundColor="0:0:0"
forceFocusOnItem="yes"
itemCornerRounding="yes"
backgroundColor="0:0:0"
sliding="yes"
bottomYPC="100"
sideTopHeightPC="100"
idleImageXPC="90"
idleImageYPC="4.5"
idleImageWidthPC="5"
idleImageHeightPC="7"
menuOffsetXPC=100
>

  <idleImage> /tmp/usbmounts/sda1/scripts/svtplay/loading/loading-1.png </idleImage>
  <idleImage> /tmp/usbmounts/sda1/scripts/svtplay/loading/loading-2.png </idleImage>
  <idleImage> /tmp/usbmounts/sda1/scripts/svtplay/loading/loading-3.png </idleImage>
  <idleImage> /tmp/usbmounts/sda1/scripts/svtplay/loading/loading-4.png </idleImage>
  <idleImage> /tmp/usbmounts/sda1/scripts/svtplay/loading/loading-5.png </idleImage>
  <idleImage> /tmp/usbmounts/sda1/scripts/svtplay/loading/loading-6.png </idleImage>

<?php
  if (count($pageArrData['menu']) > 0) {
    $menuNum = count($pageArrData['menu'])-1;

    $sepWidth = 0.5;
    $widthAll = 0;
    $menuWidths = array();
    foreach ($pageArrData['menu'] as $key => $value) {
      $width = strWidthPC($value['name'], $fontWidth_arialbd_9);
      $menuWidths[] = $width;
      $widthAll += $width + $sepWidth;
    }

    $offsetXPC = round((100 - $widthAll) / 2, 2);

    $colorDark = "60:60:60";
    $colorGreen = "0:150:0";
    $colorGrey = "104:104:104";
    foreach ($pageArrData['menu'] as $key => $value) {
      $width = $menuWidths[$key];
      $title = $value['name'];

      if ($key < 2)
        $colorBack = $colorDark;
      else
        $colorBack = $colorGrey;
  echo <<<TEXT
      <!-- menu text items -->
      <text offsetXPC=$offsetXPC offsetYPC=15.6 widthPC=$width heightPC=3.2 cornerRounding=9 fontSize=9 fontFile="/tmp/usbmounts/sda1/scripts/svtplay/arialbd.ttf" foregroundColor=255:255:255>
        <script>" $title ";</script>
        <backgroundColor>
          <script>
            if (menuSel == $key) "$colorGreen"; else "$colorBack";
          </script>
        </backgroundColor>
      </text>

TEXT;
      $offsetXPC += $width + $sepWidth;
    }
  }
?>

  <!-- selected item data start -->
  <image redraw="yes" offsetXPC="18" offsetYPC="64" widthPC="18" heightPC="18">
    <script>
      getItemInfo(-1, "thumbnail");
    </script>
  </image>

  <text redraw="yes" offsetXPC="37.7" offsetYPC="63" widthPC="30" heightPC="6" fontSize="13" lines="1" backgroundColor="0:0:0" foregroundColor="255:255:255" >
    <script>
      "Punkt: " + getPageInfo("focusItemIndex") + "/" + itemCount;
    </script>
  </text>

  <text redraw="yes" offsetXPC="37" offsetYPC="67" widthPC="50" heightPC="6" fontSize="15" backgroundColor="0:0:0" foregroundColor="255:255:255" >
    <script>
      "Titel: " + getItemInfo("title");
    </script>
  </text>
  <text redraw="yes" offsetXPC="39" offsetYPC="72" widthPC="50" heightPC="5.5" fontSize="13" backgroundColor="0:0:0" foregroundColor="255:255:255" >
    <script>
      getItemInfo("title2");
    </script>
  </text>
  <text redraw="yes" offsetXPC="39" offsetYPC="77" widthPC="50" heightPC="5.5" fontSize="13" backgroundColor="0:0:0" foregroundColor="255:255:255" >
    <script>
      getItemInfo("title3");
    </script>
  </text>
  <!-- selected item data end -->

  <itemDisplay>
    <image redraw="no" offsetXPC="1" offsetYPC="1" widthPC="100" heightPC="80">
      <script>
        thumbUrl = getItemInfo(-1, "thumbnail");
        thumbUrl;
      </script>
    </image>
    <text redraw="no" fontSize="11" alignt="justify" lines="2" offsetXPC="0" offsetYPC="88" widthPC="100" heightPC="55" backgroundColor="-1:-1:-1" foregroundColor="255:255:255">
      <script>
        getItemInfo(-1, "title");
      </script>
      </text>
  </itemDisplay>

  <backgroundDisplay>
    <!-- clear back buffer -->
    <image redraw="no" offsetXPC=0 offsetYPC=0 widthPC=100 heightPC=100>
      /tmp/usbmounts/sda1/scripts/svtplay/small_black.jpg
    </image>
    <!-- header and menu back -->
    <image redraw="no" offsetXPC="0" offsetYPC="0" widthPC="100" heightPC="20">
      /tmp/usbmounts/sda1/scripts/svtplay/blue.png
    </image>
    <!-- logo -->
    <image redraw="no" offsetXPC="5" offsetYPC="5" widthPC="7.89" heightPC="5.83">
      /tmp/usbmounts/sda1/scripts/svtplay/svt-play.png
    </image>
    <!-- title -->
    <text redraw="no" offsetXPC="25" offsetYPC="5.5" widthPC="50.7" heightPC="5.5" fontSize="20" backgroundColor="-1:-1:-1" foregroundColor="255:255:255" >
      <?= $pageArrData['title'] ?>
    </text>
    <!-- separator line after logo -->
    <image redraw="no" offsetXPC="0" offsetYPC="14" widthPC="100" heightPC="0.56">
      /tmp/usbmounts/sda1/scripts/svtplay/separator_line.png
    </image>
    <!-- separator line after menu -->
    <image redraw="no" offsetXPC="0" offsetYPC="20" widthPC="100" heightPC="0.56">
      /tmp/usbmounts/sda1/scripts/svtplay/separator_line.png
    </image>
    <!-- separator line after episodes -->
    <image redraw="no" offsetXPC="5" offsetYPC="60" widthPC="90" heightPC="0.56">
      /tmp/usbmounts/sda1/scripts/svtplay/separator_line.png
    </image>
    <!-- frame around episode -->
    <image redraw="no" offsetXPC="17" offsetYPC="62.7" widthPC="20" heightPC="20.3">
      /tmp/usbmounts/sda1/scripts/svtplay/episode_back.png
    </image>

    <!-- quality  button -->
    <image redraw="no" offsetXPC="73" offsetYPC="90" widthPC="3.36" heightPC="4.02">
      /tmp/usbmounts/sda1/scripts/svtplay/rembut/rembut_0.png
    </image>
    <!-- quality image -->
    <image redraw="yes" offsetXPC="77" offsetYPC="89.8" widthPC="6.87" heightPC="4.16">
      <script>
        "/tmp/usbmounts/sda1/scripts/svtplay/quality" + videoquality + ".gif";
      </script>
    </image>

    <!-- subtitle  button -->
    <image redraw="no" offsetXPC="85" offsetYPC="90" widthPC="3.36" heightPC="4.02">
      /tmp/usbmounts/sda1/scripts/svtplay/rembut/rembut_8.png
    </image>
    <!-- quality image -->
    <image redraw="yes" offsetXPC="90" offsetYPC="90.5" widthPC="2.34" heightPC="3.33">
      <script>
        "/tmp/usbmounts/sda1/scripts/svtplay/sub" + subtitle + ".gif";
      </script>
    </image>

    <!-- separator line after episode -->
    <!-- <image redraw="no" offsetXPC="5" offsetYPC="86" widthPC="90" heightPC="0.56">
      /tmp/usbmounts/sda1/scripts/svtplay/separator_line.png
    </image> -->

    <!-- remote buttons image and text -->

<?php
  if ($mode == 'favread') {
    echo <<< BUTTONS
    <!-- favorites -->
    <image redraw="no" offsetXPC="31" offsetYPC="90" widthPC="3.36" heightPC="4.02">
      /tmp/usbmounts/sda1/scripts/svtplay/rembut/rembut_3.png
    </image>
    <text redraw="no" offsetXPC="34" offsetYPC="89" widthPC="50.7" heightPC="5.5" fontSize="13" backgroundColor="-1:-1:-1" foregroundColor="255:255:255" >
      Ta bort favorit
    </text>

BUTTONS;
  } else if ($mode != 'getlive') {
    echo <<< BUTTONS
    <!-- search -->
    <image redraw="no" offsetXPC="7" offsetYPC="90" widthPC="3.36" heightPC="4.02">
      /tmp/usbmounts/sda1/scripts/svtplay/rembut/rembut_1.png
    </image>
    <text redraw="no" offsetXPC="10" offsetYPC="89" widthPC="50.7" heightPC="5.5" fontSize="13" backgroundColor="-1:-1:-1" foregroundColor="255:255:255" >
      Sk
    </text>
    
    <!-- favorites -->
    <image redraw="no" offsetXPC="17" offsetYPC="90" widthPC="3.36" heightPC="4.02">
      /tmp/usbmounts/sda1/scripts/svtplay/rembut/rembut_2.png
    </image>
    <text redraw="no" offsetXPC="20" offsetYPC="89" widthPC="50.7" heightPC="5.5" fontSize="13" backgroundColor="-1:-1:-1" foregroundColor="255:255:255" >
      Favoriter
    </text>
    <!-- save favorites -->
    <image redraw="no" offsetXPC="31" offsetYPC="90" widthPC="3.36" heightPC="4.02">
      /tmp/usbmounts/sda1/scripts/svtplay/rembut/rembut_3.png
    </image>
    <text redraw="no" offsetXPC="34" offsetYPC="89" widthPC="50.7" heightPC="5.5" fontSize="13" backgroundColor="-1:-1:-1" foregroundColor="255:255:255" >
      Lgg till favoriter
    </text>

    <!-- Live -->
    <image redraw="no" offsetXPC="52" offsetYPC="90" widthPC="3.36" heightPC="4.02">
      /tmp/usbmounts/sda1/scripts/svtplay/rembut/rembut_5.png
    </image>
    <text redraw="no" offsetXPC="55" offsetYPC="89" widthPC="50.7" heightPC="5.5" fontSize="13" backgroundColor="-1:-1:-1" foregroundColor="255:255:255" >
      Livesndningar
    </text>

BUTTONS;
  }
?>
  </backgroundDisplay>

  <onUserInput>
    ret="false";
    focusMenuIndex = getFocusMenuIndex();
    userInput = currentUserInput();
    /*txt = "userInput " + userInput + " focusMenuIndex " + focusMenuIndex; executeScript("log");*/
    /* only one submenu so only 0 */
    if (focusMenuIndex == 0) {
      if (userInput == "R") {
        menuSel = menuSel + 1;
        if (menuSel &gt; <?= $menuNum ?>) menuSel = 0;
        redrawDisplay();
        ret="true";
      } else if (userInput == "L") {
        menuSel = menuSel - 1;
        if (menuSel &lt; 0) menuSel = <?= $menuNum ?>;
        redrawDisplay();
        ret="true";
      } else if (userInput == "D") {
        menuSel = menuSelPrev;
        redrawDisplay();
        ret="false";
      }
    } else if (userInput == "U") {
      index=getFocusItemIndex();
      mod = index % 2;
      if (mod == 0) {
        redrawDisplay();
      }
      ret="false";
    } else if (userInput == "ENTR") {
      index = getFocusItemIndex();
      itemMode = getItemInfo(index, "mode");
      if (itemMode == "play" || itemMode == "playlive") {
        showIdle();
        itemUrl = getItemInfo(index, "url");
        playUrl = "http://127.0.0.1/media/sda1/scripts/svtplay/getShowUrl.php?mode=" + itemMode + "&amp;url=" + itemUrl;
        playItemUrl(playUrl, 0);
        ret="true";
      }
    } else if (userInput == "PD") {
      index = getFocusItemIndex();
      index = add(index, 10);
      if (index &lt; itemCount) {
        setFocusItemIndex(index);
        redrawDisplay();
      }
      ret="true";
    } else if (userInput == "PG") {
      index = getFocusItemIndex();
      index = minus(index, 10);
      if (index &gt;= 0) {
        setFocusItemIndex(index);
        redrawDisplay();
      }
      ret="true";
    } else if (userInput == "video_ffwd") {
      index = getFocusItemIndex();
      index = add(index, 30);
      if (index &lt; itemCount) {
        setFocusItemIndex(index);
        redrawDisplay();
      }
      ret="true";
    } else if (userInput == "video_frwd") {
      index = getFocusItemIndex();
      index = minus(index, 30);
      if (index &gt;= 0) {
        setFocusItemIndex(index);
        redrawDisplay();
      }
      ret="true";
    } else if (userInput == "2") {
      showIdle();
      SetBranch(1, 1);
      url = "http://127.0.0.1/media/sda1/scripts/svtplay/main_rss.php?mode=favread";
      jumpToLink("loadNewPage");
      redrawDisplay();
    } else if (userInput == "3") {
      showIdle();
      if (modeFavoritesRead == 0) {
        index = getFocusItemIndex();
        title = getItemInfo(index, "title");
        title2 = getItemInfo(index, "title2");
        title3 = getItemInfo(index, "title3");
        iconimage = getItemInfo(index, "media:thumbnail");
        mode = getItemInfo(index, "mode");
        url = getItemInfo(index, "url");
        urlFav = "http://127.0.0.1/media/sda1/scripts/svtplay/favorites.php?fav=write&amp;title=" + urlEncode(title) +
                  "&amp;title2=" + urlEncode(title2) + "&amp;title3=" + urlEncode(title3) +
                  "&amp;iconimage=" + urlEncode(iconimage) + "&amp;mode=" + mode + "&amp;url=" + urlEncode(url);
        getURL(urlFav);
        cancelIdle();
        redrawDisplay();
      } else {
        index = getFocusItemIndex();
        mode = getItemInfo(index, "mode");
        url = getItemInfo(index, "url");
        urlFav = "http://127.0.0.1/media/sda1/scripts/svtplay/favorites.php?fav=delete&amp;mode=" + mode + "&amp;url=" + urlEncode(url);
        txt = "urlFav " + urlFav; executeScript("log");
        getURL(urlFav);
        url="http://127.0.0.1/media/sda1/scripts/svtplay/main_rss.php?mode=favread";
        jumpToLink("loadNewPage");
        redrawDisplay();
      }
    } else if (userInput == "1") {
      keyword = getInput("Search", "doModal");
      if (keyword == null) {
        ret="false";
      } else {
        SetBranch(1, 1);
        url="http://127.0.0.1/media/sda1/scripts/svtplay/main_rss.php?mode=search&amp;url=1," + urlEncode(keyword);
        jumpToLink("loadNewPage");
        redrawDisplay();
      }
    } else if (userInput == "0") {
      videoquality = readStringFromFile("/tmp/usbmounts/sda1/scripts/svtplay/quality.dat");
      videoquality = add(videoquality, 1);
      if (videoquality &gt; 4)
        videoquality = 1;

      writeStringToFile("/tmp/usbmounts/sda1/scripts/svtplay/quality.dat", videoquality);
      redrawDisplay();
      ret="false";
    } else if (userInput == "8") {
    	subtitle = readStringFromFile("/tmp/usbmounts/sda1/scripts/svtplay/subtitle.dat");
      if (subtitle == 0)
        subtitle = 1;
      else
      	subtitle = 0;

      writeStringToFile("/tmp/usbmounts/sda1/scripts/svtplay/subtitle.dat", subtitle);
      redrawDisplay();
      ret="false";
    } else if (userInput == "video_search") {
      SetBranch(1, 1);
      url="http://127.0.0.1/media/sda1/scripts/svtplay/main_rss.php?mode=getlive&amp;url=dummy";
      jumpToLink("loadNewPage");
      redrawDisplay();
      
    }

    ret;
  </onUserInput>

</mediaDisplay>

<loadNewPage>
  <link>
    <script>
      url;
    </script>
  </link>
</loadNewPage>

<submenu name="submenu">
  <onClick>
    <script>
<?php
  if (count($pageArrData['menu']) > 0) {
    foreach ($pageArrData['menu'] as $key => $value) {
      if ($key >= 2) {
        // first 2 are special
        $submenu = "&amp;submenu=$key";
      } else
        $submenu = '';

      $urlData = $selfUrl . '?mode=' . $value['mode'] . '&amp;url=' . urlEncode($value['url']) . $submenu;

      if ($key == 0)
        echo 'if (menuSel == '.$key.') url = "'.$urlData.'";' . "\n";
      else
        echo 'else if (menuSel == '.$key.') url = "'.$urlData.'";' . "\n";
    }
  } else
    echo '      url = ""' . "\n";
?>
      url;
    </script>
  </onClick>
</submenu>

<channel>
<title></title>

<?php
  if (count($pageArrData['items']) > 0) {
    //print_r($pageArrData['items']);
    foreach ($pageArrData['items'] as $key => $value) {
      $title = $value['name'];
      $desc = $value['desc'];
      $extra = html_entity_decode($value['extra']);
      $iconimage = $value['iconimage'];
      $mode = $value['mode'];
      $url = $value['url'];
      $link = $selfUrl . "?mode=" . $mode . "&amp;url=" . urlEncode($url);

      echo <<< ITEM
  <item>
  <title><![CDATA[$title]]></title>
  <title2><![CDATA[$desc]]></title2>
  <title3><![CDATA[$extra]]></title3>
  <mode>$mode</mode>
  <url>$url</url>
  <link>$link</link>
  <media:thumbnail url="$iconimage"/>
  </item>

ITEM;
    }
  }
?>

</channel>
</rss>
