<?
  /*
   * ==============================================================================
   * SVT Play by Sveriges Television for Xtreamer Media Player & Streamer
   * ==============================================================================
   *
   * This project allows to watch content brom SVT Play is the brand used for the
   * video on demand service offered by Sveriges Television.
   *
   * Scraper based on SVT Play plugin for XBMC, xbmc-svtplay, code.google.com/p/xbmc-svtplay/
   *
   * Licence: GNU General Public License v2
   * http://www.gnu.org/licenses/gpl.html
   *
   * Do not remove or change any header comments! Respect our work!
   *
   * If you are satisfied with my work you can support it with small donation
   *   https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=SB8WDDAWY5YZE&lc=SI&item_name=xJukebox&item_number=ak5349jgdr&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted   *
   *
   * Author: vpeter
   *  http://forum.xtreamer.net/user/34082-vpeter/
   *
   * ==============================================================================
   */

header('Content-type: text/plain');

require_once('Lite.php');     // include the cache
require_once 'KLogger.php';   // include the logger

  define("baseurl", 'http://svtplay.se');

  $log = new KLogger("KLogger.log" , KLogger::OFF);
  //$log = new KLogger("KLogger.log" , KLogger::DEBUG);


function scrapeArrData($mode, $url)
{
global $log;

  // Set a few options
  $cache_options = array(
      'caching' => false,
      'cacheDir' => './cache/',
      'lifeTime' => 1800,
      'automaticSerialization' => true,
      'automaticCleaningFactor' => 10
  );

  $Cache_Lite = new Cache_Lite($cache_options);   // create a Cache_Lite object

  $log->LogDebug("scraper input args: mode: '$mode'  url: '$url'");

  // check the cache
  $cacheID = $mode .'_'. $url;

  if ($mode != 'play' && $mode != 'getlive' && $mode != 'playlive' && $arr = $Cache_Lite->get($cacheID)) {
    // cache hit
    $log->LogDebug("scraper cache hit");
    return $arr;
  }

  // cache miss
  //$log->LogDebug("scraper cache miss");

  $arr = array();
  $arr['menu'][] = addListItem('Program A-', '', '', baseurl . '/alfabetisk', 'list-ao');
  $arr['menu'][] = addListItem('Kategorier',  '', '', baseurl . '/kategorier', 'categories');

  if ($mode == '' || $url == '') {
    $rv = scrapePage(baseurl, $arr);
    $arr['title'] = 'Startsidan';
  } else if ($mode == 'list-ao') {
    $rv = getProgramsAO($url, $arr);
  } else if ($mode == 'categories') {
    $rv = getCategories($url, $arr);
  } else if ($mode == 'page') {
    $rv = scrapePage($url, $arr);
  } else if ($mode == 'play' || $mode == 'playlive') {
    $rv = getStreamLocation($url, $mode);
    return null;
  } else if ($mode == 'search') {
    // url = '1,some string'
    $parts = explode(',', $url, 2);
    $pagenum = $parts[0];
    $keyword = urlencode($parts[1]);
    if (count($parts) == 2) {
      $arr['title'] = 'Sk';
      $url = 'http://svtplay.se/sok?ajax,ts/ts,s,'.$pagenum.','.$keyword.',title';
      //$rv = scrapePageSearchCategory($url, $arr);
      $url = 'http://svtplay.se/sok?ajax,ps/ps,s,'.$pagenum.','.$keyword.',full';
      $rv = scrapePageSearchEpisode($url, $arr);
    }
  } else if ($mode == 'getlive') {
  	array_splice($arr['menu'], 0);		// remove menu
    $rv = getLive($arr);
  } else
    return null;

  if ($rv) {
    $Cache_Lite->save($arr, $cacheID);
    return $arr;
  }

  return null;
}

/*******************************************************************/

function getStreamLocation($url, $mode) {
global $log;

	// read socks proxy
	$socksSrv = @file_get_contents('socks_server.dat');
  if (! $socksSrv)
  	$socksSrv = '';
  else
  	$socksSrv = '&S=' . urlencode(trim($socksSrv));
  	
  // check for live stream
  if ($mode == 'playlive')
    $liveStream = '&v=1';
  else
  	$liveStream = '';
    	
  $log->LogDebug("getStreamLocation args: url: '$url'");
  $data = file_get_contents($url);
  if (! $data)
    return false;
/*
<param name="flashvars" value="pathflv=http://www0.c00928.cdn.qbrick.com/00928/kluster/20101203/C-2010-1130-STADSARKITEKTEN.flv&amp;background=http://media.svt.se/download/mcc/flash/20101203/C-2010-1130-STADSARKITEKTEN/C-2010-1130-STADSARKITEKTEN_start_0.jpg&amp;subtitle=&amp;urlinmail=http://svtplay.se/v/2256831/sa_vill_hon_bygga_staden&amp;liveStart=&amp;length=281&amp;noemail=true&amp;noembed=true&amp;autostart=true&amp;fullscreenswf=/flash/fullscreen.swf&amp;a=2256831&amp;expression=sample&amp;startpos=0&amp;expired=false&amp;statisticsUrl=http://ld.svt.se/svt/svt/s?svt-play.Nyheter.ABC.Fredagsreportage.S%E5-vill-hon-bygga-staden.2256831&amp;client=svt-play&amp;folderStructure=ABC.Klipp.Fredagsreportage&amp;title=S%E5+vill+hon+bygga+staden&amp;category=Nyheter&amp;broadcastDate=&amp;broadcastTime=&amp;mmsClientNr=1001001&amp;programId=000000" />

pathflv=http://www0.c00928.cdn.qbrick.com/00928/kluster/20101203/C-2010-1130-STADSARKITEKTEN.flv

<param name="flashvars" value="dynamicStreams=url:rtmp://fl11.c91005.cdn.qbrick.com/91005/_definst_/kluster/20101209/PG-1148017-007A-WEBBENHUMORSAJT-01-mp4-e-v1.mp4,bitrate:2400|url:rtmp://fl11.c91005.cdn.qbrick.com/91005/_definst_/kluster/20101209/PG-1148017-007A-WEBBENHUMORSAJT-01-mp4-d-v1.mp4,bitrate:1400|url:rtmp://fl11.c91005.cdn.qbrick.com/91005/_definst_/kluster/20101209/PG-1148017-007A-WEBBENHUMORSAJT-01-mp4-c-v1.mp4,bitrate:850|url:rtmp://fl11.c91005.cdn.qbrick.com/91005/_definst_/kluster/20101209/PG-1148017-007A-WEBBENHUMORSAJT-01-mp4-b-v1,bitrate:320&amp;background=http://material.svtplay.se/content/1/c8/02/26/37/10/ana_gina_del7_stor.jpg&amp;subtitle=&amp;urlinmail=http://svtplay.se/v/2263710/ana_gina_show/del_7_million_stylez_och_krak-eva_nazemson&amp;liveStart=&amp;length=906&amp;noemail=true&amp;noembed=true&amp;autostart=true&amp;fullscreenswf=/flash/fullscreen.swf&amp;a=2263710&amp;expression=full&amp;startpos=0&amp;expired=false&amp;statisticsUrl=http://ld.svt.se/svt/svt/s?svt-play.Kultur-och-n%F6je.Ana-Gina-Show.Hela-program.Del-7%3A-Million-Stylez-och-Kr%E4k-Eva-Nazemson.2263710&amp;client=svt-play&amp;folderStructure=Ana+Gina+Show.Hela+program&amp;title=Del+7%3A+Million+Stylez+och+Kr%E4k-Eva+Nazemson&amp;category=Kultur+och+n%F6je&amp;broadcastDate=20101209&amp;broadcastTime=2000&amp;mmsClientNr=1001001&amp;programId=000000" />

dynamicStreams=url:rtmp://fl11.c91005.cdn.qbrick.com/91005/_definst_/kluster/20101209/PG-1148017-007A-WEBBENHUMORSAJT-01-mp4-e-v1.mp4,bitrate:2400
  |url:rtmp://fl11.c91005.cdn.qbrick.com/91005/_definst_/kluster/20101209/PG-1148017-007A-WEBBENHUMORSAJT-01-mp4-d-v1.mp4,bitrate:1400
  |url:rtmp://fl11.c91005.cdn.qbrick.com/91005/_definst_/kluster/20101209/PG-1148017-007A-WEBBENHUMORSAJT-01-mp4-c-v1.mp4,bitrate:850
  |url:rtmp://fl11.c91005.cdn.qbrick.com/91005/_definst_/kluster/20101209/PG-1148017-007A-WEBBENHUMORSAJT-01-mp4-b-v1,bitrate:320

<param name="flashvars" value="pathflv=rtmp://fl1.c00928.cdn.qbrick.com/00928/_definst_/kluster/20081210/oa_43-1949-0000-sj149-olandsjarnvagar-tk000100&amp;background=http://material.svtplay.se/content/1/c8/01/37/12/02/oa_43-1949-0000-sj149-olandsjarnvagar-tk000100_start.jpg&amp;subtitle=&amp;urlinmail=http://svtplay.se/v/1371202/olands_jarnvagar_utan_ljud&amp;liveStart=&amp;length=1907&amp;noemail=true&amp;noembed=true&amp;autostart=true&amp;fullscreenswf=/flash/fullscreen.swf&amp;a=1371202&amp;expression=sample&amp;startpos=0&amp;expired=false&amp;statisticsUrl=http://ld.svt.se/svt/svt/s?svt-play.%D6ppet-arkiv.%D6ppet-arkiv.Fakta.P%E5-resa-genom-Sverige.%D6lands-j%E4rnv%E4gar-%28utan-ljud%29.1371202&amp;client=svt-play&amp;folderStructure=%D6ppet+arkiv.Klipp.Fakta.P%E5+resa+genom+Sverige&amp;title=%D6lands+j%E4rnv%E4gar+%28utan+ljud%29&amp;category=%D6ppet+arkiv&amp;broadcastDate=19490101&amp;broadcastTime=1533&amp;mmsClientNr=1001001&amp;programId=000000" />
*/
  $videolink_rv = preg_match('|<param name="flashvars" value="([^"]+)" />|', $data, $videolink);
  //print_r($videolink);
  if (! $videolink_rv)
    return false;

  $data = $videolink[1];

  if (preg_match('/^dynamicStreams=/', $data)) {
  	// get subtitle url
  	
  	$subtitleUse = file_get_contents('./subtitle.dat');
  	if ($subtitleUse == '1') {  	
    	$subtitle_rv = preg_match('|subtitle=([^&]+)|', $data, $subtitle);
    	if ($subtitle_rv) {
    		$subtitleUrl = $subtitle[1];
    		//echo $subtitleUrl;
    		// download and convert subtitle in background
    		$cmd = "/bin/sh download_subtitle.sh $subtitleUrl >/dev/null 2>&1 &";
				system($cmd);
    	}
    }
  	
    $videolinks_rv = preg_match_all('|url:([^,]+),bitrate:|', $data, $videolinks);
    if (! $videolinks_rv)
      return false;

    array_shift($videolinks);
    $videolinks = $videolinks[0];
    //print_r($videolinks);

    /*
        1: HD-kvalitet, 720p, 2400 kbs
        2: Hg kvalitet, 1400 kbs
        3: Medelkvalitet, 850 kbs
        4: Lag kvalitet, 340 kbs
    */
    $quality = file_get_contents('/tmp/usbmounts/sda1/scripts/svtplay/quality.dat');
    if ($quality < 1 || $quality > 4)
      $quality = 1;

    $quality = min(count($videolinks), $quality);
    $videolink = 'r=' . $videolinks[$quality -1];
    //echo "videolink: $videolink \n";
    
    $videolink .= $socksSrv;
    $videolink .= $liveStream;

    // rtmpgw
    $log->LogDebug("rtmp 1: http://127.0.0.1:7080/?$videolink'");
    header("HTTP/1.0 302 Found");
    header("Location: http://127.0.0.1:7080/?$videolink");
    die();
  } else if (preg_match('/^pathflv=/', $data)) {
    $videolink_rv = preg_match('|pathflv=([^&"]+)|', $data, $videolink);
    if (! $videolink_rv)
      return false;

    $videolink = $videolink[1];
    //print_r($videolink);
    //echo "videolink: $videolink \n";

    if (substr($videolink, 0, 7) == 'http://') {
      // http
      $log->LogDebug("http: $videolink");
      header("HTTP/1.0 302 Found");
      header("Location: $videolink");
      die();
    } else {
      // rtmpgw
      $videolink = 'r=' . urlencode($videolink);
    	$videolink .= $socksSrv;
    	$videolink .= $liveStream;
    	
      $log->LogDebug("rtmp 2: http://127.0.0.1:7080/?$videolink'");
      // GET /?r=rtmp:%2f%2fserver%2fmyapp
      header("HTTP/1.0 302 Found");
      header("Location: http://127.0.0.1:7080/?$videolink");
      die();
    }
  }

  die();
}

function scrapePageSearchCategory($url, &$arr) {
  $data = file_get_contents($url);
  if (! $data)
    return false;

/*
<li class=" first-child">
                                                <a href="/t/140131/ana_gina_show" title="Ana Gina Show r en humortalkshow med de strsta bloggprofilerna och hetaste..." class="overlay tooltip">
                            <img src="http://material.svtplay.se/content/2/c6/14/01/31/anagina-168.jpg" width="168" height="95" alt="" />
                            <span>Ana Gina Show</span>
                          </a>
                        </li>
*/
  $programs_rv = preg_match_all('|<li class="[^"]*">\W*<a href="([^"]+)" title="([^"]*)"[^>]*>\W*<img[^>]+src="([^"]+)[^>]+>\W*<span>([^>]+)</span>|', $data, $matches, PREG_SET_ORDER);
  //if (! $programs_rv)
    //return;

  //print_r($matches);
  foreach ($matches as $val) {
    $purl  = $val[1];
    $desc  = trim(html_entity_decode($val[2]));
    $image = $val[3];
    $title = '';
    $extra = '';

    if (substr_compare($purl , '/v/', 0, 3, true) == 0) {
      $arr['items'][] = addListItem($title, $desc, $extra, baseurl . $purl, "play", $image, false);
    } else if (substr_compare($purl , '?cb,', 0, 4, true) == 0) {
      $arr['items'][] = addListItem($title, $desc, $extra,  $baseurl . $purl, "page", $image);
    } else {
      if ($purl[0] != "/")
        $purl = "/" . $purl;

      $arr['items'][] = addListItem($title, $desc, $extra,  baseurl . $purl, "page", $image);
    }
  }   // foreach $matches
  //print_r($arr['items']);
  return true;
}

function getLive(&$arr) {
  //$data = file_get_contents('live.txt');
  $data = file_get_contents('http://svtplay.se/?ajax,pb/cb,a1364145,1,f,-1/pb,a1596757,1,f,');
  //echo $data;

  $data = " ". $data . "<!-- group stopper -->";
  $start = '<li class="listheading clear clearfix">';
  $end   = '<!-- group stopper -->';

  while (true) {
    $ini = strpos($data, $start);
    if ($ini == 0)
      break;

    $ini += strlen($start);
    $len = strpos($data, $end, $ini) - $ini;
    $day = substr($data, $ini, $len);
    $data = substr($data, $ini + $len);   // for next run

    $day = ereg_replace("[ \t\n\r]+", " ", $day);
    //echo "day: -->$day<--\n";

    preg_match('|([^<]*)</li>|', $day, $matches);
    $dayStr = trim($matches[1]);
    /*
    day: --> Idag</li> <li class="clear clearfix"> <div class="tablitem t1920190">
    <h3 class="expandcollapse"> Just nu:&nbsp; Rapport - Sndag</h3> <div class="collapsible" style="display: block;"> <div class="innercollapsible clearfix"> <span class="thumbnail"><!-- TODO: HERE --> <a class="tableau" href="/v/1920190/rapport/sondag"> <img class="icon-live" src="/img/icon/live-icon-anim.gif" width="48" height="20" alt="Lives&auml;ndning p&aring;g&aring;r" /> <span style="background: url('http://material.svtplay.se/content/1/c8/01/92/01/90/rapport128x72_a.jpg') no-repeat 0 0;" class="thumbwrapper {linkUrl:'/v/1920190/rapport/sondag',pathflv:'rtmp://fl10.c00928.cdn.qbrick.com/00928/enc1thumb',thumbnailSrc:'http://material.svtplay.se/content/1/c8/01/92/01/90/rapport128x72_a.jpg'}">
      <span id="t1920190" class="flashcontent islive"> <img class="thumbnail " src="http://material.svtplay.se/content/1/c8/01/92/01/90/rapport128x72_a.jpg" width="128" height="72" alt="" />
      </span> </span> </a> </span> <span class="description"> <a class="tableau" href="/v/1920190/rapport/sondag"> <em>Se LIVE-s&auml;ndningen</em> </a> </span>
      </div> <div class="clear"></div> </div> </div> </li> <li class="clear clearfix"> <div class="tablitem t1920166">
    <h3 class="expandcollapse"> 21:00 - 21:15&nbsp; Aktuellt - Sndag</h3> <div class="collapsible" style="display: block;"> <div class="innercollapsible clearfix"> <span class="thumbnail"><!-- TODO: HERE --> <a class="tableau" href="/v/1920166/aktuellt/sondag"> <img class="icon-live" src="/img/icon/live-icon-inactive.gif" width="48" height="20" alt="Lives&auml;ndning" /> <span style="background: url('http://material.svtplay.se/content/1/c8/01/92/01/66/aktuellt_ab.jpg') no-repeat 0 0;" class="thumbwrapper {linkUrl:'/v/1920166/aktuellt/sondag',pathflv:'rtmp://fl10.c00928.cdn.qbrick.com/00928/enc2thumb',thumbnailSrc:'http://material.svtplay.se/content/1/c8/01/92/01/66/aktuellt_ab.jpg'} inactive">
      <span id="t1920166" class="flashcontent"> <img class="thumbnail inactive" src="http://material.svtplay.se/content/1/c8/01/92/01/66/aktuellt_ab.jpg" width="128" height="72" alt="" />
      </span> <em class="live notnow">Ikvll 21.00</em> </span> </a> </span> <span class="description"> <a class="tableau" href="/v/1920166/aktuellt/sondag"> <em>Till s&auml;ndningen</em> </a> </span>
      </div> <div class="clear"></div> </div> </div> </li> </ul><--
    **********
    day: --> Imorgon</li> <li class="clear clearfix"> <div class="tablitem t1701080">
    <h3 class="expandcollapse"> 06:27 - 09:30&nbsp; Gomorron Sverige - Mndag</h3> <div class="collapsible" style="display: none;"> <div class="innercollapsible clearfix"> <span class="thumbnail"><!-- TODO: HERE --> <a class="tableau" href="/v/1701080/gomorron_sverige/mandag"> <img class="icon-live" src="/img/icon/live-icon-inactive.gif" width="48" height="20" alt="Lives&auml;ndning" /> <span style="background: url('http://material.svtplay.se/content/1/c8/01/70/10/80/gomorron128_4.jpg') no-repeat 0 0;" class="thumbwrapper {linkUrl:'/v/1701080/gomorron_sverige/mandag',pathflv:'rtmp://fl10.c90807.cdn.qbrick.com/90807/enc0thumb',thumbnailSrc:'http://material.svtplay.se/content/1/c8/01/70/10/80/gomorron128_4.jpg'} inactive"> <span id="t1701080" class="flashcontent"> <img class="thumbnail inactive" src="http://material.svtplay.se/content/1/c8/01/70/10/80/gomorron128_4.jpg" width="128" height="72" alt="" /> </span> <em class="live notnow">Imorgon 06.27</em> </span> </a> </span> <span class="description"> <a class="tableau" href="/v/1701080/gomorron_sverige/mandag"> Nyheter, regionala nyheter, vder, sport, ekonomi, kultur och frdjupning frn soffan. Samtal och debatter, filmrecensioner och politiska kommentarer. Nyheter varje halvtimme. Vder med lnga och korta prognoser varje halvtimme.<em>Till s&auml;ndningen</em> </a> </span> </div> <div class="clear"></div> </div> </div> </li> <li class="clear clearfix"> <div class="tablitem t2279245">
    <h3 class="expandcollapse"> 12:20 - 13:35&nbsp; Skidor - Lngd Tour de Ski 3/1 12:20</h3> <div class="collapsible" style="display: none;"> <div class="innercollapsible clearfix"> <span class="thumbnail"><!-- TODO: HERE --> <img class="icon-live" src="/img/icon/live-icon-inactive.gif" width="48" height="20" alt="Lives&auml;ndning" /> <span style="background: url('http://material.svtplay.se/content/1/c8/02/27/92/45/hellner_128x72.jpg') no-repeat 0 0;" class="thumbwrapper {linkUrl:'/v/2279245/skidor/langd_tour_de_ski_3_1_12_20',pathflv:'rtmp://fl10.c90807.cdn.qbrick.com/90807/enc0thumb',thumbnailSrc:'http://material.svtplay.se/content/1/c8/02/27/92/45/hellner_128x72.jpg'} inactive"> <span id="t2279245" class="flashcontent"> <img class="thumbnail inactive" src="http://material.svtplay.se/content/1/c8/02/27/92/45/hellner_128x72.jpg" width="128" height="72" alt="" /> </span> <em class="live notnow">Imorgon 12.20</em> </span> </span> <span class="description"> Direktsndning av herrarnas dubbeljakt 10+10 km i Tour de Ski i Oberstdorf.</span> </div> <div class="clear"></div> </div> </div> </li> <li class="clear clearfix"> <div class="tablitem t2279328">
    <h3 class="expandcollapse"> 15:35 - 16:30&nbsp; Skidor - Lngd Tour de Ski 3/1 15:35</h3> <div class="collapsible" style="display: none;"> <div class="innercollapsible clearfix"> <span class="thumbnail"><!-- TODO: HERE --> <img class="icon-live" src="/img/icon/live-icon-inactive.gif" width="48" height="20" alt="Lives&auml;ndning" /> <span style="background: url('http://material.svtplay.se/content/1/c8/02/27/93/28/hellner_128x72.jpg') no-repeat 0 0;" class="thumbwrapper {linkUrl:'/v/2279328/skidor/langd_tour_de_ski_3_1_15_35',pathflv:'rtmp://fl10.c90807.cdn.qbrick.com/90807/enc0thumb',thumbnailSrc:'http://material.svtplay.se/content/1/c8/02/27/93/28/hellner_128x72.jpg'} inactive"> <span id="t2279328" class="flashcontent"> <img class="thumbnail inactive" src="http://material.svtplay.se/content/1/c8/02/27/93/28/hellner_128x72.jpg" width="128" height="72" alt="" /> </span> <em class="live notnow">Imorgon 15.35</em> </span> </span> <span class="description"> Direktsndning av damernas dubbeljakt 5+5 km i Tour de Ski i Oberstdorf.</span> </div> <div class="clear"></div> </div> </div> </li> <li class="clear clearfix"> <div class="tablitem t1919374">
    <h3 class="expandcollapse"> 19:30 - 20:00&nbsp; Rapport - Mndag</h3> <div class="collapsible" style="display: none;"> <div class="innercollapsible clearfix"> <span class="thumbnail"><!-- TODO: HERE --> <img class="icon-live" src="/img/icon/live-icon-inactive.gif" width="48" height="20" alt="Lives&auml;ndning" /> <span style="background: url('http://material.svtplay.se/content/1/c8/01/91/93/74/rapport128x72_a.jpg') no-repeat 0 0;" class="thumbwrapper {linkUrl:'/v/1919374/rapport/mandag',pathflv:'rtmp://fl10.c00928.cdn.qbrick.com/00928/enc1thumb',thumbnailSrc:'http://material.svtplay.se/content/1/c8/01/91/93/74/rapport128x72_a.jpg'} inactive"> <span id="t1919374" class="flashcontent"> <img class="thumbnail inactive" src="http://material.svtplay.se/content/1/c8/01/91/93/74/rapport128x72_a.jpg" width="128" height="72" alt="" /> </span> <em class="live notnow">Imorgon 19.30</em> </span> </span> <span class="description"> </span> </div> <div class="clear"></div> </div> </div> </li> <li class="clear clearfix"> <div class="tablitem t2278575">
    <h3 class="expandcollapse"> 21:30 - 00:10&nbsp; Ishockey - JVM semifinal 1 3/1 21:30</h3> <div class="collapsible" style="display: none;"> <div class="innercollapsible clearfix"> <span class="thumbnail"><!-- TODO: HERE --> <img class="icon-live" src="/img/icon/live-icon-inactive.gif" width="48" height="20" alt="Lives&auml;ndning" /> <span style="background: url('http://material.svtplay.se/content/1/c8/02/27/85/75/tjarnqvist_128x72.jpg') no-repeat 0 0;" class="thumbwrapper {linkUrl:'/v/2278575/ishockey/jvm_semifinal_1_3_1_21_30',pathflv:'rtmp://fl10.90807.cdn.qbrick.com/90807/enc4thumb',thumbnailSrc:'http://material.svtplay.se/content/1/c8/02/27/85/75/tjarnqvist_128x72.jpg'} inactive"> <span id="t2278575" class="flashcontent"> <img class="thumbnail inactive" src="http://material.svtplay.se/content/1/c8/02/27/85/75/tjarnqvist_128x72.jpg" width="128" height="72" alt="" /> </span> <em class="live notnow">Imorgon 21.30</em> </span> </span> <span class="description"> Direktsndning frn Ishockey-VM fr Juniorer. Semifinal 1. <br />Matchen spelas i Buffalo, USA.</span> </div> <div class="clear"></div> </div> </div> </li> </ul><--
    */
    $programs_rv = preg_match_all('|.*?<h3 class="expandcollapse">([^<]*).*?linkUrl:\'([^\']*)\'.*?thumbnailSrc:\'([^\']*)\'.*?class="flashcontent([^"]*)".*?<span class="description">(.*?)</li>|', $day, $matches, PREG_SET_ORDER);
    //print_r($matches);
    foreach ($matches as $key => $day) {
      array_shift($day);

      $day[0] = $dayStr .' / '. trim(html_entity_decode(strip_tags($day[0])));

      $programs_rv = preg_match('|<a class="[^"]*" href="[^"]*">(.*?)</div>|', $day[4], $matches);
      if ($programs_rv == 1) {
        $day[4] = trim(html_entity_decode(strip_tags($matches[1])));
      } else
        $day[4] = trim(html_entity_decode(strip_tags($day[4])));

      //$day[] = $dayStr;
      //print_r($day);

/*
    [0] => Idag / Just nu:  Rapport - Sndag
    [1] => /v/1920190/rapport/sondag
    [2] => http://material.svtplay.se/content/1/c8/01/92/01/90/rapport128x72_a.jpg
    [3] => 1
    [4] => Se LIVE-sndningen
*/
      $title = $day[0];
      $desc = $day[4];
      if (trim($day[3]) == 'islive')
        $extra = 'Nu Live :)';
      else
        $extra = 'Maste vnta en tid';

      $url = baseurl . $day[1];
      $image = $day[2];

      $arr['items'][] = addListItem($title, $desc, $extra, $url, "playlive", $image, false);
    }
  }
  return true;
}

function scrapePageSearchEpisode($url, &$arr) {
  $data = file_get_contents($url);
  if (! $data)
    return false;

/*
<li class=" first-child">
                                                <a href="/v/2281339/ana_gina_show/del_10__bloggerskan_kissie_och_lyxfallan-vanita" title="Del 10 av 20. Kissie och Vanita kommer till showen och hjlper Gina att sammanfatta 2010..." class="overlay tooltip">
                            <img src="http://media.svt.se/download/mcc/kluster/20101229/PG-1148017-010A-WEBBENHUMORSAJT-01_0_thumb_0.jpg" width="128" height="72" alt="" />
                            <span>
                              Ana Gina Show - Del 10: Bloggerskan Kissie och...</span>
                            <em>S&auml;ndes: igar 20.00&nbsp;</em>
                              </a>
                        </li>
*/
  $programs_rv = preg_match_all('|<li class="[^"]*">\W*<a href="([^"]+)" title="([^"]*)"[^>]*>\W*<img[^>]+src="([^"]+)[^>]+>\W*<span>([^>]+)</span>\W*<em>(.*)</em>|', $data, $matches, PREG_SET_ORDER);
  //if (! $programs_rv)
    //return;

  //print_r($matches);
  foreach ($matches as $val) {
    $purl  = $val[1];
    $desc  = trim(html_entity_decode($val[2]));
    $image = $val[3];
    $title = trim(html_entity_decode($val[4]));
    $extra = trim(html_entity_decode($val[5]));

    if (substr_compare($purl , '/v/', 0, 3, true) == 0) {
      $arr['items'][] = addListItem($title, $desc, $extra, baseurl . $purl, "play", $image, false);
    } else if (substr_compare($purl , '?cb,', 0, 4, true) == 0) {
      $arr['items'][] = addListItem($title, $desc, $extra,  $baseurl . $purl, "page", $image);
    } else {
      if ($purl[0] != "/")
        $purl = "/" . $purl;

      $arr['items'][] = addListItem($title, $desc, $extra,  baseurl . $purl, "page", $image);
    }
  }   // foreach $matches
  //print_r($arr['items']);

  /* get page count */
  /*
      <ul class="list small {pagenum:2,rssLink:''}">
      <ul class="list {pagenum:4,rssLink:''}">
      <ul class="list small first-child {pagenum:2,rssLink:''}">
  */
  $pagecount_rv = preg_match_all('|<ul class=[^{]+{pagenum:(\d+)[^"]*">[\W\w]+?</ul>|', $data, $matches_pagecount, PREG_SET_ORDER);
  //print_r($matches_pagecount);
  if (! $pagecount_rv)
    return true;

  $pagecount = $matches_pagecount[0][1];
  //echo "pagecount=$pagecount\n";

/*
http://svtplay.se/sok?ajax,ps/ps,s,1,ana+gina,full
*/
  //echo $url;
  $it = explode(',', $url, 6);
  //print_r($it);

  if (count($it) >= 6) {
    $current = $it[3];
    //echo "count:  $current < $pagecount \n";
    if ($current < $pagecount) {
      $it[3] = $current + 1;
      $it1 = implode(',', $it);
      $arr['items'][] = addListItem('Nsta sida...', '', '', $it[3].','.$it[4], "search");
    }
  }
  //print_r($arr['items']);

  return true;
}

function scrapePage($url, &$arr) {
  //echo "url: $url\n";
  $data = file_get_contents($url);
  if (! $data)
    return false;

  $arr['title'] = getPageTitle($data);
  getNavigation($url, $data, $arr);
  getItems($url, $data, $arr);
  return true;
}

function getPageTitle($data) {
  //echo $data;
  $data = ereg_replace("[ \t\n\r]+", " ", $data);   // replace multiple character with one space

  /* get page title */
  /*  <span class="category">Kategori: <a href="/c/96252/oppet_arkiv">ppet arkiv</a></span>  */
  $category_rv = preg_match('|<span class="category">Kategori: <a href="[^"]*">([^<]*)</a></span>|', $data, $matches);
  //print_r($matches);
  if (! $category_rv)
    $title = '';
  else
    $title = trim($matches[1]);

  $data1 = getStringBetween($data, '<div class="info">', '</div>');
  //echo $data1;
  $category_rv = preg_match('|<a href="[^"]*">([^<]*)</a>|', $data1, $matches);
  //print_r($matches);
  $title2 = trim($matches[1]);
  if ($category_rv && $title != $title2)
    $title .= ' / ' . $title2;

  if ($title == '') {
/*
<div class="sb-header" id="cl">
    <h1>Samhlle och fakta</h1>
</div>
*/
  $category_rv = preg_match('|<div class="sb-header" id="cl">\W*<h1>([^<]*)</h1>|', $data, $matches);
  //print_r($matches);
  if ($category_rv)
    $title = trim($matches[1]);
  }

  //echo "title: $title\n";
  return $title;
}

function getNavigation($url, $data, &$arr) {
  /* get navigation items */
  $data_navigation = getStringBetween($data, '<!-- begin tab navigation -->', '<!-- end tab navigation -->');
  //echo $data_navigation;

  $uls_rv = preg_match_all('|<ul class="[^"]*">[\W\w]+?</ul>|', $data_navigation, $matches_uls, PREG_SET_ORDER);
  if (! $uls_rv)
    return;
  //print_r($matches_uls);

  foreach ($matches_uls as $ul) {
    //echo "1 =>" . $ul[0] ."\n\n";
/*
<li class="selected">
    <h2><a href="?cb,a1364145,1,f,103212/pb,a1364142,1,f,103212/pl,v,,1370350/sb,b1387574,1,f," class="internal" >Rekommenderat</a>
        </h2></li>
*/
    $programs_rv = preg_match_all('|<li class="[^"]*">\W*(<h2>)?<a href="([^"]+)"[^>]*>([^<]+)</a>\W*(</h2>)?</li>|', $ul[0], $matches, PREG_SET_ORDER);
    if (! $programs_rv)
      return;

    if ($programs_rv < 2)
      return $arr;    // don't display just one

    $baseurl = substr($url, 0, strpos($url, '?cb,'));
    if (! $baseurl)
      $baseurl = $url;

    //print_r($matches);
    foreach ($matches as $val) {
      $purl  = $val[2];
      $title = $val[3];

      if ($title == 'Livesändningar')
        continue;   // skip live

      if (substr_compare($purl , '?cb,', 0, 4, true) == 0) {
        if ($purl[0] != "/")
          $purl = "/" . $purl;

        $arr['menu'][] = addListItem($title, $desc, '', $baseurl . $purl, "page", $image, false);
      }
    }
  }

  return $arr;
}

function getItems($url, $data, &$arr) {
  /* get items */
  $data_items = getStringBetween($data, '<!-- Render items -->', '<!--End Render items-->');
  //echo $data_items;

  /* get page count */
  /*
      <ul class="list small {pagenum:2,rssLink:''}">
      <ul class="list {pagenum:4,rssLink:''}">
      <ul class="list small first-child {pagenum:2,rssLink:''}">
  */
  $pagecount_rv = preg_match_all('|<ul class=[^{]+{pagenum:(\d+)[^"]*">[\W\w]+?</ul>|', $data_items, $matches_pagecount, PREG_SET_ORDER);
  if (! $pagecount_rv)
    return;
  //print_r($matches_pagecount);
  $pagecount = $matches_pagecount[0][1];
  //echo "pagecount=$pagecount\n";

  $uls_rv = preg_match_all('|<ul class="list[^"]*">[\W\w]+?</ul>|', $data_items, $matches_uls, PREG_SET_ORDER);
  if (! $uls_rv)
    return;
  //print_r($matches_uls);

  //$arr = array();
  foreach ($matches_uls as $ul) {
    //echo "2 => " . $ul[0] ."\n\n";

    $baseurl = substr($url, 0, strpos($url, '?cb,'));
    if (! $baseurl)
      $baseurl = $url;

    $str = ereg_replace("[ \t\n\r]+", " ", $ul[0]);   // replace multiple character with one space
    $str = preg_replace('/<li class="/', "\n<li class=\"", $str);
    //echo $str;
/*
http://svtplay.se/c/96252/oppet_arkiv
title + Kategori: ppet arkiv

<li class=" first-child a2279519">
  <a href="/t/134027/premiar__minuten" title="Minuten: Rafflande familjeunderhallning" class="overlay tooltip">
  <img src="http://material.svtplay.se/content/2/c6/13/40/27/miuten-168.jpg" width="168" height="95" alt="" />
  <!-- span > Premir: Minuten - Premir: Minuten</span --> <span>Premir: Minuten</span> </a> </li>

<li class=" first-child selected a1387654">
  <a href="/v/1371799/morgongymnastik_med_bertil_uggla" title="Bertil Uggla demonstrerar en nagot annorlunda variant av morgongymnastik med hjlp av..." class="overlay tooltip">
  <img src="http://material.svtplay.se/content/1/c8/01/37/17/99/oa_43-1934-0000-SF2646-morgongympa_thumb.jpg" width="128" height="72" alt="" />
  <!-- span > Morgongymnastik med Bertil Uggla</span --> <span>Morgongymnastik med Bertil Uggla</span> <em>Fr&aring;n: 1 jan 1934</em> <em>L&auml;ngd: 04:03</em> </a> </li>
<
*/
    $programs_rv = preg_match_all('|<li class="[^"]*">\W*<a href="([^"]+)" title="([^"]*)"[^>]*>\W*<img[^>]+src="([^"]+)[^>]+>\W*(<!--[^/]+/span -->\W+){0,1}<span>([^>]+)</span>(\W<em>([^<]+)</em>\W<em>([^<]+)</em>)?|', $str, $matches, PREG_SET_ORDER);
    //print_r($matches);
    foreach ($matches as $val) {
      $purl  = $val[1];
      $desc  = trim(html_entity_decode($val[2]));
      $image = $val[3];
      $title = trim(html_entity_decode($val[5]));
      $extra = trim(html_entity_decode($val[6])) .', ' . trim(html_entity_decode($val[7]));
      $extra = preg_replace('#</?em[^>]*>#is', '', $extra);
      if ($extra == ', ')
        $extra = '';

      if (substr_compare($purl , '/v/', 0, 3, true) == 0) {
        $arr['items'][] = addListItem($title, $desc, $extra, baseurl . $purl, "play", $image, false);
      } else if (substr_compare($purl , '?cb,', 0, 4, true) == 0) {
        $arr['items'][] = addListItem($title, $desc, $extra,  $baseurl . $purl, "page", $image);
      } else {
        if ($purl[0] != "/")
          $purl = "/" . $purl;

        $arr['items'][] = addListItem($title, $desc, $extra,  baseurl . $purl, "page", $image);
      }
    }   // foreach $matches
/*
http://svtplay.se/c/96252/oppet_arkiv?cb,a1364145,1,f,103035/pb,a1364142,1,f,103035/pl,v,,1371799/sb,k103107,1,f,

<li class=" first-child a103108"> <a href="?cb,a1364145,1,f,103035/pb,a1364142,1,f,103035/pl,v,,1371799/sb,k103107,1,f,103108" title="" class="folder overlay tooltip">
  <img src="/img/background/folder-sb.gif" width="98" height="71" alt="" />
  <img class="folder-thumb" src="http://material.svtplay.se/content/2/c6/10/31/08/almstriden_m.jpg" width="80" height="45" alt="" />
  <span>Almstriden</span> </a> </li>
*/
    $programs_rv = preg_match_all('|<li class="[^"]*">\W*<a href="([^"]+)" title="([^"]*)"[^>]*>\W*<img[^>]+src="[^>]+>\W*<img[^>]+src="([^"]+)[^>]+>\W*(<!--[^/]+/span -->\W+){0,1}<span>([^>]+)</span>|', $str, $matches, PREG_SET_ORDER);
    //print_r($matches);
    foreach ($matches as $val) {
      $purl  = $val[1];
      $desc  = trim(html_entity_decode($val[2]));
      $image = $val[3];
      $title = trim(html_entity_decode($val[5]));
      $extra = '';

      if (substr_compare($purl , '/v/', 0, 3, true) == 0) {
        $arr['items'][] = addListItem($title, $desc, $extra, baseurl . $purl, "play", $image, false);
      } else if (substr_compare($purl , '?cb,', 0, 4, true) == 0) {
        $arr['items'][] = addListItem($title, $desc, $extra,  $baseurl . $purl, "page", $image);
      } else {
        if ($purl[0] != "/")
          $purl = "/" . $purl;

        $arr['items'][] = addListItem($title, $desc, $extra,  baseurl . $purl, "page", $image);
      }
    }   // foreach $matches

/*
http://svtplay.se/v/2109734

<li class=" first-child a2109734">
  <a href="/v/2109734/gabba_gabba/the_weekend_19_-_det_ar_mycket_man_skulle_gjort.?cb,,1,f,-1/pb,a1364150,1,f,-1/pl,v,,2277637/sb,k136649,1,f,-1" title="" class="overlay tooltip">
  <img class="thumbnail" src="http://media.svt.se/download/mcc/flash/20100818/GABBAGABBA-WEEKEND19/GABBAGABBA-WEEKEND19_thumb_0.jpg" width="128" height="72" alt="" />
  <span > The weekend 19 - Det är mycket man skulle gjort.</span>
  <em> Ons 22 dec&nbsp;<span class="nowrap">L&auml;ngd: 02:50</span> </em> </a> </li>

*/
    $programs_rv = preg_match_all('|<li class="[^"]*">\W*<a href="([^"]+)" title="([^"]*)"[^>]*>\W*<img[^>]+src="([^"]+)[^>]+>\W*(<span >)([^>]+)</span>\W*<em>(.*)</em>|', $str, $matches, PREG_SET_ORDER);
    //print_r($matches);
    foreach ($matches as $val) {
      $purl  = $val[1];
      $desc  = trim(html_entity_decode($val[2]));
      $image = $val[3];
      $title = trim(html_entity_decode($val[5]));
      $extra = trim(html_entity_decode($val[6]));
      $extra = preg_replace('#</?span[^>]*>#is', '', $extra);
      $extra = preg_replace('#</?em[^>]*>#is', '', $extra);

      if (substr_compare($purl , '/v/', 0, 3, true) == 0) {
        $arr['items'][] = addListItem($title, $desc, $extra, baseurl . $purl, "play", $image, false);
      } else if (substr_compare($purl , '?cb,', 0, 4, true) == 0) {
        $arr['items'][] = addListItem($title, $desc, $extra,  $baseurl . $purl, "page", $image);
      } else {
        if ($purl[0] != "/")
          $purl = "/" . $purl;

        $arr['items'][] = addListItem($title, $desc, $extra,  baseurl . $purl, "page", $image);
      }
    }   // foreach $matches

/*
page
/c/
  /t/
?cb,      we need original uri in front

play
/v/

this is page
http://svtplay.se/t/146704/raddningspatrullen
http://svtplay.se/t/113351/allt_om_djur
*/
  }

/*
next page: http://svtplay.se/c/96256/kultur_och_noje?cb,a1364155,1,f,-1pb,a1364154,2,f,-1
http://svtplay.se/pb,a1364154,2,f,-1
*/

  $path_parts = pathinfo($url);
  $it = explode(',', $path_parts['basename'], 4);
  //print_r($it);

  if (count($it) == 1) {
    //    <li class=" selected"><a href="?cb,a1364155,1,f,-1/pb,a1364154,1,f,-1" class="internal ">1</a></li>
    $page_rv = preg_match('|<li class="[^"]*"><a href="([^"]*)" class="internal ">1</a></li>|', $data, $matches_page);
    if (! $page_rv)
      return;
    //print_r($matches_page);
    //  ?cb,a1364155,1,f,-1/pb,a1364154,1,f,-1
    $path_parts = pathinfo($matches_page[1]);
    $url = $url .'/'. $path_parts['dirname'];
    $it = explode(',', $path_parts['basename'], 4);
    //print_r($it);
  }

  $url = $url . '/';

  $current = $it[2];
  //echo "count:  $current < $pagecount \n";
  if ($current < $pagecount) {
    $it[2] = $current + 1;
    $it = implode(',', $it);
    $arr['items'][] = addListItem('Nsta sida...', '', '', $url . $it, "page");
  }
  return $arr;
}

function getCategories($url, &$arr) {
  $data = file_get_contents($url);
  if (! $data)
    return false;
  $ul = preg_match_all('|<ul class="list category-list[^"]*">[\W\w]+?</ul>|', $data, $matches);
  if (! $ul)
    return false;
  $data = $matches[0][0];
  $categories = preg_match_all('|<li class="[^"]*">\W+<div class="container">\W*<a href="([^"]+)"[^>]*>\W*<img[^>]+src="([^"]+)[^>]+>\W*<span class="bottom"></span>\W*<span class="[^"]*">([^>]+)</span>|', $data, $matches, PREG_SET_ORDER);
  if (! $categories)
    return;
  unset($data);
  foreach ($matches as $val) {
    $curl  = $val[1];
    $image = $val[2];
    $title = $val[3];
    if ($curl[0] != '/')
      $curl = "/" . $curl;

    $arr['items'][] = addListItem($title, $desc, '', baseurl . $curl, "page", $image);
  }
  unset($matches);
  return true;
}

function getProgramsAO($url, &$arr) {
  $data = file_get_contents($url);
  if (! $data)
    return false;
  $programs_rv = preg_match_all('|<li>[\s]*<a href="([^"]+)">([^<]+)</a>[\s]*</li>|', $data, $matches, PREG_SET_ORDER);
  if (! $programs_rv)
    return false;
  unset($data);
  foreach ($matches as $val) {
    $purl  = $val[1];
    $title = $val[2];
    $arr['items'][] = addListItem($title, $desc, '', baseurl . $purl, "page");
  }
  unset($matches);
  return true;
}

function addListItem($title, $desc ='', $extra ='', $url, $mode, $iconimage='', $folder=True) {
  //$title = preg_replace("/&amp;/", "&", $title);
  $title = trim(htmlspecialchars_decode($title));

  if ($iconimage == '')
    $iconimage = '/tmp/usbmounts/sda1/scripts/svtplay/svtplay_logo.jpg';

  $arr = array('name'       => $title,
               'desc'       => $desc,
               'extra'      => $extra,
               'mode'       => $mode,
               'url'        => $url,
               'iconimage'  => $iconimage,
               'folder'     => $folder
              );
  return $arr;
}

function getStringBetween($string, $start, $end, $num = 0) {
  //$string = trim($string, " \r\n\t");
  $string = " ". $string;

  if ($num > 0) {
    for ($i = 0; $i < $num; $i++) {
      $ini = strpos($string, $start);
      if ($ini == 0)
        return "";

      $string = substr($string, $ini + 1);
    }
  }

  $ini = strpos($string, $start);
  if ($ini == 0)
    return "";
  $ini += strlen($start);
  $len = strpos($string, $end, $ini) - $ini;
  $ret = substr($string, $ini, $len);
  $ret = str_replace('<br /><br />', '', $ret);
  return trim($ret, " \r\n\t");
}

?>