/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2004, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	rt3070.c

	Abstract:
	Specific funcitons and variables for RT3070

	Revision History:
	Who         When          What
	--------    ----------    ----------------------------------------------
*/

#ifdef RT3070

#include "rt_config.h"


#ifndef RTMP_RF_RW_SUPPORT
#error "You Should Enable compile flag RTMP_RF_RW_SUPPORT for this chip"
#endif // RTMP_RF_RW_SUPPORT //


VOID NICInitRT3070RFRegisters(IN PRTMP_ADAPTER pAd)
{
	INT i;
	UCHAR RFValue;
	
	// Driver must read EEPROM to get RfIcType before initial RF registers
	// Initialize RF register to default value
	if (IS_RT3070(pAd) || IS_RT3071(pAd))
	{
		// Init RF calibration
		// Driver should toggle RF R30 bit7 before init RF registers
		UINT32 RfReg = 0;          
		UINT32 data;          

                RT30xxReadRFRegister(pAd, RF_R30, (PUCHAR)&RfReg);
                RfReg |= 0x80;
                RT30xxWriteRFRegister(pAd, RF_R30, (UCHAR)RfReg);
                RTMPusecDelay(1000);
                RfReg &= 0x7F;
                RT30xxWriteRFRegister(pAd, RF_R30, (UCHAR)RfReg);        

                // Initialize RF register to default value
		for (i = 0; i < NUM_RF_3020_REG_PARMS; i++)
                {
                        RT30xxWriteRFRegister(pAd, RT3020_RFRegTable[i].Register, RT3020_RFRegTable[i].Value);
                }
 
		// init R31
		RT30xxWriteRFRegister(pAd, RF_R31, 0x14);

		// add by johnli
		if (IS_RT3070(pAd))
		{
			//
			// The DAC issue(LDO_CFG0) has been fixed in RT3070(F). 
			// The voltage raising patch is no longer needed for RT3070(F)	
			//
			if ((pAd->MACVersion & 0xffff) < 0x0201)
			{
				//  Update MAC 0x05D4 from 01xxxxxx to 0Dxxxxxx (voltage 1.2V to 1.35V) for RT3070 to improve yield rate
				RTUSBReadMACRegister(pAd, LDO_CFG0, &data);
				data = ((data & 0xF0FFFFFF) | 0x0D000000);
				RTUSBWriteMACRegister(pAd, LDO_CFG0, data);
			}
		}
		else if (IS_RT3071(pAd))
		{
			// Driver should set RF R6 bit6 on before init RF registers		
			RT30xxReadRFRegister(pAd, RF_R06, (PUCHAR)&RfReg);
			RfReg |= 0x40;
			RT30xxWriteRFRegister(pAd, RF_R06, (UCHAR)RfReg);

			// RT3071 version E has fixed this issue
			if ((pAd->NicConfig2.field.DACTestBit == 1) && ((pAd->MACVersion & 0xffff) < 0x0211))
			{
				// patch tx EVM issue temporarily
				RTUSBReadMACRegister(pAd, LDO_CFG0, &data);
				data = ((data & 0xE0FFFFFF) | 0x0D000000);
				RTUSBWriteMACRegister(pAd, LDO_CFG0, data);
			}
			else
			{
				RTMP_IO_READ32(pAd, LDO_CFG0, &data);
				data = ((data & 0xE0FFFFFF) | 0x01000000);
				RTMP_IO_WRITE32(pAd, LDO_CFG0, data);
			}

			// patch LNA_PE_G1 failed issue
			RTUSBReadMACRegister(pAd, GPIO_SWITCH, &data);
			data &= ~(0x20);
			RTUSBWriteMACRegister(pAd, GPIO_SWITCH, data);
		}
		
                //For RF filter Calibration
		RTMPFilterCalibration(pAd);

		// Initialize RF R27 register, set RF R27 must be behind RTMPFilterCalibration()
		// 
		// TX to RX IQ glitch(RF_R27) has been fixed in RT3070(F). 
		// Raising RF voltage is no longer needed for RT3070(F)
		//	
		if ((IS_RT3070(pAd)) && ((pAd->MACVersion & 0xffff) < 0x0201))
		{
			RT30xxWriteRFRegister(pAd, RF_R27, 0x3);
		}
		else if ((IS_RT3071(pAd)) && ((pAd->MACVersion & 0xffff) < 0x0211))
		{
			RT30xxWriteRFRegister(pAd, RF_R27, 0x3);
		}

		// set led open drain enable
		RTUSBReadMACRegister(pAd, OPT_14, &data);
		data |= 0x01;
		RTUSBWriteMACRegister(pAd, OPT_14, data);

		if (IS_RT3071(pAd))
		{
			// RF power sequence setup, load RF normal operation-mode setup
			RT30xxLoadRFNormalModeSetup(pAd);
		}
		else if (IS_RT3070(pAd))
		{	
		// TX_LO1_en, RF R17 register Bit 3 to 0
		RT30xxReadRFRegister(pAd, RF_R17, &RFValue);
		RFValue &= (~0x08);
		// to fix rx long range issue
		if (pAd->NicConfig2.field.ExternalLNAForG == 0)
		{
			if ((IS_RT3071(pAd) && ((pAd->MACVersion & 0xffff) >= 0x0211)) || IS_RT3070(pAd))
			{
				RFValue |= 0x20;
			}
		}
		// set RF_R17_bit[2:0] equal to EEPROM setting at 0x48h
		if (pAd->TxMixerGain24G >= 1)
		{
			RFValue &= (~0x7);  // clean bit [2:0]
			RFValue |= pAd->TxMixerGain24G;
		}
		RT30xxWriteRFRegister(pAd, RF_R17, RFValue);
		
			/* add by johnli, reset RF_R27 when interface down & up to fix throughput problem*/
			// LDORF_VC, RF R27 register Bit 2 to 0
			RT30xxReadRFRegister(pAd, RF_R27, &RFValue);
			// TX to RX IQ glitch(RF_R27) has been fixed in RT3070(F). 
			// Raising RF voltage is no longer needed for RT3070(F)
			if ((pAd->MACVersion & 0xffff) < 0x0201)
				RFValue = (RFValue & (~0x77)) | 0x3;
			else
				RFValue = (RFValue & (~0x77));
			RT30xxWriteRFRegister(pAd, RF_R27, RFValue);
			/* end johnli */
		}
        }	

}
#endif // RT3070 //

